<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Product;


class Voucher extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'code',
        'min_order_value',
        'max_discount',
        'voucher_value',
        'start_date',
        'expiration_date',
        'applied_to',
        'applied_to_spo',
        'customer_type',
        'combine_with_other_vouchers',
        'redemption_limit',
        'times_redeemed',
        'is_active',
        'type'
    ];

    protected $casts = [
        'start_date' => 'date',
        'expiration_date' => 'date',
        'combine_with_other_vouchers' => 'boolean',
        'is_active' => 'boolean'
    ];

    // You can define a method to check if the voucher is expired.
    public function isExpired()
    {
        return strtotime($this->expiration_date) < time();
    }

    public function isNewUser($userId)
    {
        $user = \App\Models\User::find($userId);
        $registrationDate = Carbon::parse($user->created_at);
        return $registrationDate->diffInDays(Carbon::now()) <= 30; // User registered within 30 days
    }

    // A function to check if the voucher is applied by the user
    public function isAppliedByUser($userId)
    {
        return Booking::where('voucher_id', $this->id)
            ->where('user_id', $userId)
            ->exists();
    }
    public function isApplicableForUser($userId)
    {
        if ($this->customer_type == 'new' && $this->isNewUser($userId)) {
            return true;
        }
        if ($this->customer_type == 'existing' && !$this->isNewUser($userId)) {
            return true;
        }
        if ($this->customer_type == 'all') {
            return true;
        }
        return false;
    }
    public function products()
    {
        return $this->belongsToMany(Product::class, 'products', 'id', 'id')
            ->whereIn('id', json_decode($this->applied_to ?? '[]'));
    }

    public function getAppliedProductNamesAttribute()
    {
        $ids = json_decode($this->applied_to, true);
        if (empty($ids)) return [];

        return Product::whereIn('id', $ids)->pluck('name')->toArray();
    }

}