<?php
namespace App\Services;

use App\Models\Booking;
use Stripe\Stripe;
use Stripe\Checkout\Session;

class PaymentLinkService
{
    public function regenerate(Booking $booking): string
    {
        Stripe::setApiKey(env('STRIPE_SECRET_KEY'));

        $bookingItems = $booking->bookingItems;

        $lineItems = $bookingItems->map(function ($item) {
            return [
                'price_data' => [
                    'currency' => 'eur',
                    'product_data' => [
                        'name' => $item->product_name,
                    ],
                    'unit_amount' => (int) ($item->calculated_rent * 100),
                ],
                'quantity' => 1,
            ];
        })->toArray();

        $session = Session::create([
            'payment_method_types' => ['card', 'paypal', 'amazon_pay'],
            'line_items' => $lineItems,
            'mode' => 'payment',
            'metadata' => [
                'booking_id' => $booking->id,
                'user_id' => $booking->user_id,
            ],
            'success_url' => route('checkout.success') . '?session_id={CHECKOUT_SESSION_ID}',
            'cancel_url' => route('checkout.cancel') . '?session_id={CHECKOUT_SESSION_ID}',
        ]);

        $booking->update([
            'stripe_session_id' => $session->id,
            'last_payment_link_sent_at' => now(),
        ]);

        return $session->url;
    }
}
