<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('admin_holidays_table', function (Blueprint $table) {
        $table->id();
        $table->foreignId('admin_id')->constrained()->onDelete('cascade');
        $table->string('name')->nullable(); 
        $table->date('date')->nullable(); 
        $table->time('days_left')->nullable();
        $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('admin_holidays_table');

    }
};
