<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('meta_title');
            $table->string('sub_title')->nullable();
            $table->unsignedBigInteger('category_id')->nullable();
            $table->string('size_variation')->nullable();
            $table->string('product_brand')->nullable();
            $table->string('color')->nullable();
            $table->integer('quantity')->nullable();
            $table->decimal('rental_price_day', 8, 2)->nullable();
            $table->decimal('rental_price_week', 8, 2)->nullable();
            $table->decimal('rental_price_after_week', 8, 2)->nullable();
            $table->string('dimensions_heigth')->nullable();
            $table->string('dimensions_width')->nullable();
            $table->string('product_weight')->nullable();
            $table->string('status')->nullable();
            $table->string('keywords')->nullable();
            $table->string('related_product_condition')->nullable();
            $table->text('meta_description')->nullable();
            $table->json('images')->nullable();
            $table->string('main_image')->nullable();
            $table->integer('active')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
