<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists('variations');
        Schema::dropIfExists('sizes');

        Schema::create('sizes', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // e.g., S, M, L
            $table->string('label')->nullable(); // Optional label like "Small"
            $table->timestamps();
        });
        // Recreate variations table
        Schema::create('variations', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // e.g., "Gold Edition"
            
            $table->timestamps();


        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sizes', function (Blueprint $table) {
            Schema::dropIfExists('variations');
            Schema::dropIfExists('sizes');
        });
    }
};
