<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColorSizeVariationToCategories extends Migration
{
    public function up()
    {
        Schema::table('categories', function (Blueprint $table) {
            $table->json('color_ids')->nullable()->after('name');
            $table->json('size_ids')->nullable()->after('color_ids');
            $table->json('variation_ids')->nullable()->after('size_ids');
        });
    }

    public function down()
    {
        Schema::table('categories', function (Blueprint $table) {
            $table->dropColumn(['color_ids', 'size_ids', 'variation_ids']);
        });
    }
}

