<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('product_variations', function (Blueprint $table) {
            $table->dropForeign(['size_id']);
            $table->unsignedBigInteger('size_id')->nullable()->change();
            $table->foreign('size_id')->references('id')->on('sizes')->onDelete('set null');

            $table->unsignedBigInteger('variation_id')->nullable()->after('size_id');
            $table->foreign('variation_id')->references('id')->on('variations')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::table('product_variations', function (Blueprint $table) {
            $table->dropForeign(['variation_id']);
            $table->dropColumn('variation_id');

            $table->dropForeign(['size_id']);
            $table->unsignedBigInteger('size_id')->nullable(false)->change();
            $table->foreign('size_id')->references('id')->on('sizes')->onDelete('cascade');
        });
    }
};
