<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cart_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('cascade');
            $table->foreignId('product_id')->constrained();
            $table->string('product_name');
            $table->string('car_name')->nullable();
            $table->year('car_year')->nullable();
            $table->string('model')->nullable();
            $table->boolean('trailer_hitch')->nullable();
            $table->string('roof_type')->nullable();
            $table->string('color')->nullable();
            $table->string('size')->nullable();
            $table->boolean('is_carrier_included')->default(false);
            $table->boolean('is_insured')->default(false);
            $table->date('pickup_date')->nullable();
            $table->integer('days');
            $table->date('dropoff_date')->nullable();
            $table->time('dropoff_time')->nullable();
            $table->decimal('calculated_rent', 10, 2)->nullable();
            $table->string('status')->default('pending');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cart_items');
    }
};
