<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('cart_items', function (Blueprint $table) {
            $table->string('carrier_length')->nullable();
            $table->string('foot_sku')->nullable()->after('carrier_length');
            $table->string('footkit_sku')->nullable()->after('foot_sku');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('cart_items', function (Blueprint $table) {
            $table->dropColumn(['carrier_length', 'foot_sku', 'footkit_sku']);
        });
    }
};
