<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('booking_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('booking_id')->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            $table->unsignedBigInteger('product_id');
            $table->string('product_name');
            $table->string('car_name')->nullable();
            $table->string('car_year')->nullable();
            $table->string('model')->nullable();
            $table->boolean('trailer_hitch')->default(false);
            $table->string('roof_type')->nullable();
            $table->string('color')->nullable();
            $table->string('size')->nullable();
            $table->boolean('is_carrier_included')->default(false);
            $table->boolean('is_insured')->default(false);
            $table->date('pickup_date');
            $table->date('dropoff_date');
            $table->time('pickup_time')->nullable();   // Format: 09:00 - 11:00
            $table->time('dropoff_time')->nullable();
            $table->integer('days');
            $table->string('footkit_sku')->nullable();
            $table->string('foot_sku')->nullable();
            $table->string('carrier_length')->nullable();
            $table->decimal('calculated_rent', 10, 2);
            $table->string('status')->default('pending'); // Item-level status if needed
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booking_items');
    }
};
