<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('vouchers', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('code')->unique();
            $table->decimal('min_order_value', 10, 2);
            $table->decimal('max_discount', 10, 2);
            $table->date('start_date');
            $table->date('expiration_date');
            $table->text('applied_to')->nullable(); 
            $table->enum('customer_type', ['all', 'new', 'existing'])->default('all');
            $table->boolean('combine_with_other_vouchers')->default(true);
            $table->integer('redemption_limit')->nullable();
            $table->integer('times_redeemed')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('vouchers');
    }
};