<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();

            // Event type (e.g. payment_link_sent, contact_us, slot_change_request, cancellation, voucher_limit, newsletter_unsubscribed)
            $table->string('type');

            // Status or state of the notification (e.g. sent, expired, paid, unread)
            $table->string('status')->nullable();

            // Related user info
            $table->unsignedBigInteger('user_id')->nullable();
            $table->string('customer_name');
            $table->string('customer_email')->nullable();
            $table->string('customer_phone')->nullable();

            // Optional related data (e.g. booking ID, voucher ID, message, etc.)
            $table->json('data')->nullable();

            $table->boolean('is_read')->default(false);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notifications');
    }
};
