<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('product_variation_options', function (Blueprint $table) {
            // Get the actual foreign key constraint name from the database
            $constraint = DB::selectOne("
                SELECT CONSTRAINT_NAME 
                FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE 
                WHERE TABLE_NAME = 'product_variation_options' 
                AND COLUMN_NAME = 'variation_id' 
                AND CONSTRAINT_NAME <> 'PRIMARY'
            ");
            
            // Drop the existing foreign key constraint if it exists
            if ($constraint) {
                $table->dropForeign([$constraint->CONSTRAINT_NAME]);
            }
            
            // Add the new foreign key constraint with CASCADE on delete
            $table->foreign('variation_id')
                  ->references('id')
                  ->on('product_variations')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('product_variation_options', function (Blueprint $table) {
            // Drop the foreign key constraint
            $table->dropForeign(['variation_id']);
        });
    }
};
