<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('vendors', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->string('first_name');
            $table->string('last_name');
            $table->string('email')->unique();
            $table->string('profile_image')->nullable();
            $table->string('country_code')->nullable();
            $table->string('number')->nullable();
            $table->string('password');
            $table->string('street')->nullable();
            $table->string('zip_code')->nullable();
            $table->string('city')->nullable();
            $table->string('country')->nullable();
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->boolean('is_deleted')->default(false);
            $table->string('business_model')->nullable();
            $table->string('size_of_location')->nullable();
            $table->rememberToken();
            $table->timestamps();
            $table->boolean('new_in_business')->default(0);
            $table->index(['email']);
            $table->index(['status']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('vendors');
    }
};