<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('vendors', function (Blueprint $table) {
            $table->string('business_type')->nullable()->after('size_of_location');
            $table->string('contact_person')->nullable()->after('business_type');
            $table->string('tax_number')->nullable()->after('contact_person');
            $table->string('tax_id')->nullable()->after('tax_number');
            $table->string('bank_name')->nullable()->after('tax_id');
            $table->string('account_owner')->nullable()->after('bank_name');
            $table->string('account_number')->nullable()->after('account_owner');
            $table->string('bic_number')->nullable()->after('account_number');
            $table->string('iban_number')->nullable()->after('bic_number');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vendors', function (Blueprint $table) {
            $table->dropColumn([
                'business_type',
                'contact_person',
                'tax_number',
                'tax_id',
                'bank_name',
                'account_owner',
                'account_number',
                'bic_number',
                'iban_number',
            ]);
        });
    }
};
