<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('vendor_holidays', function (Blueprint $table) {
            $table->dropColumn(['start_date', 'end_date', 'reason']);

            $table->string('name')->after('vendor_id');
            $table->date('date')->after('name');
            $table->integer('days_left')->nullable()->after('date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::table('vendor_holidays', function (Blueprint $table) {
            $table->dropColumn(['name', 'date', 'days_left']);

            $table->date('start_date')->after('vendor_id');
            $table->date('end_date')->after('start_date');
            $table->string('reason')->after('end_date');
        });
    }
};
