<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bundle', function (Blueprint $table) {
            $table->id();
            $table->string('car_make')->nullable();
            $table->string('model')->nullable();
            $table->string('type_year')->nullable();
            $table->string('rooftype_ger')->nullable();
            $table->string('rooftype_eng')->nullable();
            $table->string('recommended_roofbox_size')->nullable();
            $table->string('carrier_length')->nullable();
            $table->string('foot_sku')->nullable();
            $table->string('footkit_sku')->nullable();
            $table->string('bundle_name')->nullable();
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bundle');
    }
};
