<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vendors_product_quantities', function (Blueprint $table) {
            $table->id();
        
            $table->unsignedBigInteger('vendor_id');
            $table->foreign('vendor_id')->references('id')->on('vendors')->onDelete('cascade');
        
            $table->unsignedBigInteger('product_variation_option_id');
            $table->foreign('product_variation_option_id')->references('id')->on('product_variation_options')->onDelete('cascade');
        
            $table->integer('quantity')->default(0);
        
            $table->string('sku')->nullable();
        
         
        
     
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vendors_product_quantites');
    }
};
