<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->boolean('delay')->default(0);
            $table->decimal('delay_fees', 10, 2)->nullable();
            $table->integer('additional_days')->nullable();
            $table->date('new_dropoff_date')->nullable();
            $table->boolean('damage')->default(0);



        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->dropColumn([
                'delay' , 'delay_fees','additional_days','new_dropoff_date','damage'
            ]);
        });
    }
};
