<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->string('delay_session_id')->nullable();
            $table->timestamp('last_delay_payment_link_sent_at')->nullable()->after('payment_status');   
            $table->boolean('delay_fees_paid')->default(0);


        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->dropColumn([
                'delay_session_id','last_delay_payment_link_sent_at','delay_fees_paid'
             ]);
        });
    }
};
