<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('booking_requests', function (Blueprint $table) {
            $table->id();
            $table->string('booking_request_id')->unique(); 
            $table->string('customer_name');
            $table->string('customer_email');
            $table->string('customer_phone')->nullable();

            $table->string('product_name')->nullable();
            $table->string('color_name')->nullable();
            $table->string('size_or_variation')->nullable();
            $table->string('carrier_length')->nullable();
            $table->string('foot_sku')->nullable();
            $table->string('footkit_sku')->nullable();
            $table->string('manufacturer')->nullable();
            $table->string('car_model')->nullable();
            $table->string('car_year')->nullable();
            $table->string('trailer_hitch')->nullable();
            $table->string('roof_type')->nullable();

            $table->date('rental_from')->nullable();
            $table->date('rental_to')->nullable();

            $table->string('pickup_location')->nullable();
            $table->string('city')->nullable();
            $table->string('zipcode')->nullable();
            $table->string('street')->nullable();
            $table->string('state')->nullable();

            $table->text('unavailable_components')->nullable();
            $table->text('message')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booking_requests');
    }
};
