<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
</head>

<body>
    <div class="email-block" style="    width: 100%;max-width: 700px;">
        <div class="email-banner" style="position: relative; max-height: 524px;">

            <img class="e-logo" src="{{ asset('frontend/images/logo.png')}}" alt="" style="    position: absolute; left: 50%; top: 27px;
    transform: translateX(-50%); width: 100%; max-width: 240px;">
            <img src="{{ asset('frontend/images/banner.png')}}" alt="">

        </div>
        <div class="email-body" style="padding: 50px 30px;">
            <h2 style="    font-family: Arial;
    font-weight: 700;
    font-size: 24px;
    line-height: 100%; text-align: center;">Confirmation</h2>
            <p style="font-family: Arial; font-weight: 400;font-size: 16px;line-height: 24px;text-align: center; margin: 30px 0px; color: #111111;
">Dear <b>{{ $userDetails->first_name }} {{ $userDetails->last_name }}</b>,<br>
Thank you for your booking! Your invoice will be sent to you in a separate email.</p>

 @if(!auth()->check())
 <p style="font-family: Arial; font-weight: 400;font-size: 16px;line-height: 24px; color: #111111;
"><b>Don't forget to create a customer account. There you can:</b><br></p>
<ul style="font-family: Arial; font-weight: 400;font-size: 16px;line-height: 24px; color: #666;padding-left: 25px;

">
    <li>View your personal details and orders</li>
    <li>Access an overview of your appointments with us</li>
    <li>Check and use available vouchers</li>
    <li>Easily reschedule appointments</li>
    <li>Conveniently cancel orders and much more!</li>
</ul>
<p style="font-family: Arial; font-weight: 400;font-size: 16px;line-height: 24px; color: #666;margin-bottom: 40px;
">Sign up now and take advantage of the benefits of your customer account!</p>
<a href="#" style="    text-decoration: none;
    font-family: Oswald;
    font-weight: 400;
    font-size: 16px;
    line-height: 100%;
    vertical-align: middle;
    text-transform: uppercase;
    padding: 13px 18px;
    background: #5BC0DE;
    border-radius: 4px;
    color: #fff; display: inline-block;">Sign UP NOW </a>

     @endif

    <p style="font-family: Arial; font-weight: 400;font-size: 16px;line-height: 24px; color: #111111;margin-top: 30px;"><b>Cancellation Policy</b><br>Cancellations are free of charge up to 48 hours before the pick-up time. For cancellations made less than 48 hours before the scheduled pick-up, 100% of the booking costs will apply.
    You can easily cancel through your customer account or contact us at cs@dachboxit.de</p>

<div class="table-block">
<p style="font-family: Arial; font-weight: 400;font-size: 16px;line-height: 24px; color: #111111;margin-top: 30px; margin-bottom: 10px;"><b>Booking Details:</b></p>
<table style="width:100%; border-collapse: separate; border-spacing:0; font-family: Arial; font-size:16px; font-weight:400; line-height:100%;">
  <!-- Booking ID -->
  <tr>
    <td style="background-color:#c7edf7; color:#111111; padding:12px 0 12px 30px; border-top-left-radius:5px; border-bottom-left-radius:5px;">Booking ID</td>
    <td style="background-color:#c7edf7; color:#666666; padding:12px 0 12px 30px; border-top-right-radius:5px; border-bottom-right-radius:5px;">#{{ str_pad($booking->id, 6, '0', STR_PAD_LEFT) }}</td>
  </tr>
  <!-- Booking Date -->
  <tr>
    <td style="color:#111111; padding:12px 0 12px 30px;">Booking Date</td>
    <td style="color:#666666; padding:12px 0 12px 30px;">{{ $booking->created_at->format('d.m.Y') }}</td>
  </tr>
  <!-- Booking Status -->
  <tr>
    <td style="background-color:#c7edf7; color:#111111; padding:12px 0 12px 30px; border-top-left-radius:5px; border-bottom-left-radius:5px;">Booking Status</td>
    <td style="background-color:#c7edf7; color:#666666; padding:12px 0 12px 30px; border-top-right-radius:5px; border-bottom-right-radius:5px;">{{ ucfirst($booking->status) }}</td>
  </tr>
  <!-- Payment Method -->
  <tr>
    <td style="color:#111111; padding:12px 0 12px 30px;">Payment Method</td>
    <td style="color:#666666; padding:12px 0 12px 30px;">{{ ucfirst($booking->payment_method) }}</td>
  </tr>
  <!-- Rental Period -->

  @foreach($bookingItems as $item)
   @if(!$item->related_item)
  <tr>
    <td style="background-color:#c7edf7; color:#111111; padding:12px 0 12px 30px; border-top-left-radius:5px; border-bottom-left-radius:5px;">Rental Period</td>
    <td style="background-color:#c7edf7; color:#666666; padding:12px 0 12px 30px; border-top-right-radius:5px; border-bottom-right-radius:5px;">
      {{ \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') }} - {{ \Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y') }}</td>
    </td>
  </tr>
  <!-- Rental Days -->
  <tr>
    <td style="color:#111111; padding:12px 0 12px 30px;">Rental Days</td>
    <td style="color:#666666; padding:12px 0 12px 30px;">{{ \Carbon\Carbon::parse($item->pickup_date)->diffInDays(\Carbon\Carbon::parse($item->dropoff_date)) }}</td>
  </tr>
  <!-- Pickup Location -->
  <tr>
    <td style="background-color:#c7edf7; color:#111111; padding:12px 0 12px 30px; border-top-left-radius:5px; border-bottom-left-radius:5px;">Pickup Location</td>
    <td style="background-color:#c7edf7; color:#666666; padding:12px 0 12px 30px; border-top-right-radius:5px; border-bottom-right-radius:5px;">
      {{ $admin->address }}, {{ $admin->zip_code }} {{ $admin->city }}</td>
  </tr>
  <!-- Pick-Up Date/Time -->
  <tr>
    <td style="color:#111111; padding:12px 0 12px 30px;">Pick-Up Date/Time</td>
    <td style="color:#666666; padding:12px 0 12px 30px;">
                  {{ \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') }} | 
                  {{ $item->pickup_time ? \Carbon\Carbon::parse($item->pickup_time)->format('H:i') : '' }}</td>
  </tr>
  <!-- Drop-Off Date/Time -->
  <tr>
    <td style="background-color:#c7edf7; color:#111111; padding:12px 0 12px 30px; border-top-left-radius:5px; border-bottom-left-radius:5px;">Drop-Off Date/Time</td>
    <td style="background-color:#c7edf7; color:#666666; padding:12px 0 12px 30px; border-top-right-radius:5px; border-bottom-right-radius:5px;">
                  {{ \Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y') }} | 
                  {{ $item->dropoff_time ? \Carbon\Carbon::parse($item->dropoff_time)->format('H:i') : '' }}</td>
  </tr>
  <!-- Carrier Included -->
  <tr>
    <td style="color:#111111; padding:12px 0 12px 30px;">Carrier Included</td>
    <td style="color:#666666; padding:12px 0 12px 30px;">
     @if($item->is_carrier_included)
          Length: {{ $item->carrier_length ?? 'N/A' }}<br>
          Foot Kit: {{ $item->carrier_foot_kit ?? 'N/A' }}<br>
          Foot: {{ $item->carrier_foot ?? 'N/A' }}
      @else
          No
      @endif
    </td>
  </tr>
  <!-- Volkassko Insurance -->
  <tr>
    <td style="background-color:#c7edf7; color:#111111; padding:12px 0 12px 30px; border-top-left-radius:5px; border-bottom-left-radius:5px;">Volkassko Insurance 25 €</td>
    <td style="background-color:#c7edf7; color:#666666; padding:12px 0 12px 30px; border-top-right-radius:5px; border-bottom-right-radius:5px;">{{ $item->is_insured ? 'Included' : 'Not Included' }}</td>
  </tr>
  <!-- Mounting Services -->
  <tr>
    <td style="color:#111111; padding:12px 0 12px 30px;">Mounting Services</td>
    <td style="color:#666666; padding:12px 0 12px 30px;">{{ $item->mounting_service ? 'Included' : 'Not Included' }}</td>
  </tr>
  <!-- Cleaning Service -->
  <tr>
    <td style="background-color:#c7edf7; color:#111111; padding:12px 0 12px 30px; border-top-left-radius:5px; border-bottom-left-radius:5px;">Cleaning Service</td>
    <td style="background-color:#c7edf7; color:#666666; padding:12px 0 12px 30px; border-top-right-radius:5px; border-bottom-right-radius:5px;">
          {{ $item->cleaning_service ? 'Included' : 'Not Included' }}
    </td>
  </tr>
  @endif
  @endforeach
  <!-- Coupon Discount -->
  <tr>
    <td style="color:#111111; padding:12px 0 12px 30px;">Coupon Discount</td>
    <td style="color:#666666; padding:12px 0 12px 30px;">
      {{ number_format($booking->discount ?? 0, 2) }}€
    </td>
  </tr>
  <!-- Subtotal -->
  <tr>
    <td style="background-color:#c7edf7; color:#111111; padding:12px 0 12px 30px; border-top-left-radius:5px; border-bottom-left-radius:5px;">Subtotal</td>
    <td style="background-color:#c7edf7; color:#666666; padding:12px 0 12px 30px; border-top-right-radius:5px; border-bottom-right-radius:5px;">
      {{ number_format($booking->subtotal, 2) }}€
    </td>
  </tr>
  <!-- Tax -->
  <tr>
    <td style="color:#111111; padding:12px 0 12px 30px;">Tax (19%)</td>
    <td style="color:#666666; padding:12px 0 12px 30px;">
      {{ number_format($booking->tax, 2) }}€
    </td>
  </tr>
  <!-- Total -->
  <tr>
    <td style="background-color:#c7edf7; color:#111111; padding:12px 0 12px 30px; border-top-left-radius:5px; border-bottom-left-radius:5px;">Total</td>
    <td style="background-color:#c7edf7; color:#666666; padding:12px 0 12px 30px; border-top-right-radius:5px; border-bottom-right-radius:5px;">
      {{ number_format($booking->total, 2) }}€ 
    </td>
  </tr>
</table>
</div>

        <div class="table-block">
  <p style="font-family: Arial; font-weight: 400; font-size: 16px; line-height: 24px; color: #111111; margin-top: 30px; margin-bottom: 10px;">
    <b>Product Details:</b>
  </p>
  <table style="width:100%; border: 1px solid #5BC0DE; border-collapse: separate; border-spacing:0; font-family: Arial; font-size:16px; font-weight:400; line-height:100%;">
    @foreach($bookingItems as $item)
     @if(!$item->related_item)
    <tr>
      <td style="width:50%;background-color:#c7edf7; color:#111111; padding:12px 0 12px 30px; border-top-left-radius:5px; border-bottom-left-radius:5px;">Product ID</td>
      <td style="width:50%;background-color:#c7edf7; color:#666666; padding:12px 0 12px 30px; border-top-right-radius:5px; border-bottom-right-radius:5px;">#{{ str_pad($item->product_id, 6, '0', STR_PAD_LEFT) }}</td>
    </tr>
    <tr>
      <td style="width:50%;color:#111111; padding:12px 0 12px 30px;">Product Name</td>
      <td style="width:50%;color:#666666; padding:12px 0 12px 30px;">{{ $item->product_name }}</td>
    </tr>
    <tr>
      <td style="width:50%;background-color:#c7edf7; color:#111111; padding:12px 0 12px 30px;">Quantity</td>
      <td style="width:50%;background-color:#c7edf7; color:#666666; padding:12px 0 12px 30px;">1</td>
    </tr>
    <tr>
      <td style="width:50%;color:#111111; padding:12px 0 12px 30px;">Size/Variation</td>
      <td style="width:50%;color:#666666; padding:12px 0 12px 30px;">{{ $item->size }}</td>
    </tr>
    <tr>
      <td style="width:50%;background-color:#c7edf7; color:#111111; padding:12px 0 12px 30px;">Color</td>
      <td style="width:50%;background-color:#c7edf7; color:#666666; padding:12px 0 12px 30px;">{{ $item->color }}</td>
    </tr>
    @endif
    @endforeach
  </table>
      </div>

<div class="table-block">
  <p style="font-family: Arial; font-weight: 400; font-size: 16px; line-height: 24px; color: #111111; margin-top: 30px; margin-bottom: 10px;">
    <b>Car Details:</b>
  </p>
  <table style="width:100%; border: 1px solid #5BC0DE; border-collapse: separate; border-spacing:0; font-family: Arial; font-size:16px; font-weight:400; line-height:100%;">
    @foreach($bookingItems as $item)
     @if(!$item->related_item)
    <tr>
      <td style="width:50%;background-color:#c7edf7; color:#111111; padding:12px 0 12px 30px; border-top-left-radius:5px; border-bottom-left-radius:5px;">Brand</td>
      <td style="width:50%;background-color:#c7edf7; color:#666666; padding:12px 0 12px 30px; border-top-right-radius:5px; border-bottom-right-radius:5px;">{{ $item->car_name }}</td>
    </tr>
    <tr>
      <td style="width:50%;color:#111111; padding:12px 0 12px 30px;">Year</td>
      <td style="width:50%;color:#666666; padding:12px 0 12px 30px;">{{ $item->car_year }}</td>
    </tr>
    <tr>
      <td style="width:50%;background-color:#c7edf7; color:#111111; padding:12px 0 12px 30px;">Model</td>
      <td style="width:50%;background-color:#c7edf7; color:#666666; padding:12px 0 12px 30px;">{{ $item->model }}</td>
    </tr>
    <tr>
      <td style="width:50%;color:#111111; padding:12px 0 12px 30px;">Trailer Hitch</td>
      <td style="width:50%;color:#666666; padding:12px 0 12px 30px;">{{ $item->trailer_hitch ? 'Yes' : 'No' }}</td>
    </tr>
    <tr>
      <td style="width:50%;background-color:#c7edf7; color:#111111; padding:12px 0 12px 30px;">Roof Type</td>
      <td style="width:50%;background-color:#c7edf7; color:#666666; padding:12px 0 12px 30px;">{{ $item->roof_type }}</td>
    </tr>
    @endif
    @endforeach
  </table>
</div>

<div class="table-block">
  <p style="font-family: Arial; font-weight: 400; font-size: 16px; line-height: 24px; color: #111111; margin-top: 30px; margin-bottom: 10px;">
    <b>Customer Details:</b>
  </p>
  <table style="width:100%; border: 1px solid #5BC0DE; border-collapse: separate; border-spacing:0; font-family: Arial; font-size:16px; font-weight:400; line-height:100%;">
    <tr>
      <td style="width:50%;background-color:#c7edf7; color:#111111; padding:12px 0 12px 30px; border-top-left-radius:5px; border-bottom-left-radius:5px;">Customer ID</td>
      <td style="width:50%;background-color:#c7edf7; color:#666666; padding:12px 0 12px 30px; border-top-right-radius:5px; border-bottom-right-radius:5px;">#{{ str_pad($userDetails->user_id, 6, '0', STR_PAD_LEFT) }}</td>
    </tr>
    <tr>
      <td style="width:50%;color:#111111; padding:12px 0 12px 30px;">Customer Name</td>
      <td style="width:50%;color:#666666; padding:12px 0 12px 30px;">{{ $userDetails->first_name }} {{ $userDetails->last_name }}</td>
    </tr>
    <tr>
      <td style="width:50%;background-color:#c7edf7; color:#111111; padding:12px 0 12px 30px;">Address</td>
      <td style="width:50%;background-color:#c7edf7; color:#666666; padding:12px 0 12px 30px;">
        {{ $userDetails->address }}, {{ $userDetails->zip }} <br> {{ $userDetails->city }}, <br> {{ $userDetails->country }}
      </td>
    </tr>
    <tr>
      <td style="width:50%;color:#111111; padding:12px 0 12px 30px;">Email Address</td>
      <td style="width:50%;color:#666666; padding:12px 0 12px 30px;">{{ $userDetails->email }}</td>
    </tr>
    <tr>
      <td style="width:50%;background-color:#c7edf7; color:#111111; padding:12px 0 12px 30px;">Phone Number</td>
      <td style="width:50%;background-color:#c7edf7; color:#666666; padding:12px 0 12px 30px;">{{ $userDetails->phone }}</td>
    </tr>
    <tr>
      <td style="width:50%;color:#111111; padding:12px 0 12px 30px;">Invoice Number</td>
      <td style="width:50%;color:#666666; padding:12px 0 12px 30px;">{{ $booking->invoice_number}}</td>
    </tr>
  </table>
</div>


<p style="font-family: Arial;
    font-weight: 400;
    font-size: 16px;
    line-height: 24px;
    color: #000000; margin-top: 30px;">If you have any questions regarding your booking or would like to place a new booking, our customer service team will be happy to assist you. Please contact us at cs@dachboxit.de.<br><br>Best regards,<br>Your Dachboxit Team</p>
        </div>

    <div class="email-footer" style="    padding: 31px 45px 81px;
    background: #111111;    display: flex
;
    justify-content: center;
    align-items: center;
    flex-direction: column;
    gap: 30px;
    border-bottom: 1px solid #383838;
">
        <img src="{{ asset('frontend/images/logo.png')}}" alt="">
        <p style="    font-family: Arial;
    font-weight: 400;
    font-size: 15px;
    line-height: 24px;
    text-align: center;
    color: #fff;">If you have any questions or need to make changes to your booking, feel free to contact us</p>
        <div class="e-social" style="    display: flex
;
    gap: 10px;
    align-items: flex-start;">
            <div class="e-s-list" style="    display: flex
;
    flex-direction: column;
    align-items: center;
    gap: 10px;">
                <img src="{{ asset('frontend/images/Message.png')}}" alt="" style="    width: 20px;
    height: 20px;
    object-fit: contain;">
                <p style="    font-family: Arial;
    font-weight: 400;
    font-size: 14px;
    line-height: 24px;
    text-align: center;
    color: #fff;">cs@dachboxit.de</p>
            </div>
            <div class="e-s-list" style="    display: flex
;
    flex-direction: column;
    align-items: center;
    gap: 10px;">
                <img src="{{ asset('frontend/images/Mobile.png')}}" alt="" style="    width: 20px;
    height: 20px;
    object-fit: contain;">
                <p style="    font-family: Arial;
    font-weight: 400;
    font-size: 14px;
    line-height: 24px;
    text-align: center;
    color: #fff;">+4915172876293</p>
            </div>
        </div>
        <p><a href="" style="   font-family: Arial;
    font-weight: 400;
    font-size: 14px;
    line-height: 24px;
    text-align: center;
    color: #fff; text-decoration: none;">Privacy Policy  |  AGB's</a></p>
        <p style="   font-family: Arial;
    font-weight: 400;
    font-size: 14px;
    line-height: 24px;
    text-align: center;
    color: #fff;">Rerent Esperantostrasse 10, 70197 Stuttgart, Germany <br>Usatzsteuer-ID: DE300067568</p>
    </div>
    <div class="copy-right" style="background-color: #111111; padding: 15px 30px;">
        <p style=" font-family: Arial;
    font-weight: 400;
    font-size: 14px;
    line-height: 24px;
    text-align: center;
    color: #fff;">© 2025 Dachboxit. All rights reserved.</p>
    </div>
        </div>
</body>

</html>