$('.hero-slider').owlCarousel({
    loop: true,
    margin: 0,
    nav: false,
    arrows:false,
    items: 1,
    dots:true,
    smartSpeed: 600,
    // autoplay: true,
    // autoplayTimeout: 4000,
    // autoplayHoverPause: true,
    animateOut: 'fadeOut',
    animateIn: 'fadeIn',

});

$('.review-wrapper').owlCarousel({
    loop: true,
    margin: 20,
    nav: true,
    items: 3,
    smartSpeed: 600,
    autoplay: true,
    autoplayTimeout: 4000,
    autoplayHoverPause: true,
    animateOut: 'fadeOut',
    animateIn: 'fadeIn',
    dots: false, responsive:{
        0:{
            items:1
        },
        600:{
            items:1
        },
        1000:{
            items:3
        }
    }
});

$(document).ready(function() {
    // Live search functionality
    let searchTimeout;
    const $searchInput = $('.search-input');
    const $searchResults = $('.search-results-dropdown');
  
    $searchInput.on('input', function() {
      clearTimeout(searchTimeout);
      const query = $(this).val().trim();
      
      if (query.length < 2) {
        $searchResults.hide().empty();
        return;
      }
      
      searchTimeout = setTimeout(() => {
        $.ajax({
            url: window.searchRoute,
          type: "GET",
          data: { query: query },
          success: function(data) {
            displaySearchResults(data);
          },
          error: function(xhr) {
            console.error('Search error:', xhr.responseText);
          }
        });
      }, 300);
    });
  
    // Hide results when clicking outside
    $(document).on('click', function(e) {
      if (!$(e.target).closest('.search-container').length) {
        $searchResults.hide();
      }
    });
  
    // Prevent form submission
    $('.search-form').on('submit', function(e) {
      e.preventDefault();
    });
  
    function displaySearchResults(products) {
      $searchResults.empty();
      
      if (products.length === 0) {
        $searchResults.append('<div class="no-results">No products found</div>');
      } else {
        products.forEach(product => {
            const productUrl = product.product_url;
            const imageUrl = product.image_url;
          
            $searchResults.append(`
              <div class="search-result-item" data-url="${productUrl}">
                <div class="search-result-content">
                  <img src="${imageUrl}" alt="${product.name}" class="search-result-image">
                  <div class="search-result-text">
                    <div class="search-result-title">${product.name}</div>
                  </div>
                </div>
              </div>
            `);
          });
        
        // Add click handler for results
        $('.search-result-item').on('click', function() {
            window.location.href = $(this).data('url');
          });
      }
      
      $searchResults.show();
    }
  });

