@extends('layouts.admin')
@section('content')
<style>
    .is-invalid {
        border-color: #dc3545;
    }

    .error-message {
        margin-top: 2px;
        font-size: 15px;

    }
</style>
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="{{route('admin.profile')}}">My profile</a>
            <a class="active">Edit profile</a>
        </div>
    </div>
    <div class="add-user-form">
        <form class="validation row g-3" method="Post" action="{{ route('admin.update.profile',$admin) }}" enctype="multipart/form-data">
            @csrf
            <div class="col-md-12">
                <div class="profile-pic"><label class="-label" for="file"><span class="glyphicon glyphicon-camera"><i class="fas fa-camera"></i></span></label><input name="image" type="file" id="file" accept="image/*" class="form-control" onchange="previewImage(event)">
                    @if($admin->image)
                    <figure class="profile-img"><img id="preview" src="{{ asset('storage/'.$admin->image) }}" alt="Profile Image"></figure>
                    @else
                    <figure class="profile-img"><img id="preview" src="{{asset('admin/images/profile.png')}}" alt=""></figure>
                    @endif
                </div>
            </div>
            <div class="col-md-1">
                <div class="comn-input-select">
                    <label for="inputtitle" class="form-label">title</label>
                    <select id="inputtitle" class="form-select" name="title">
                        <option value="mr" selected>Mr.</option>
                        <option value="mrs">Mrs.</option>
                        <option value="ms">Ms.</option>
                    </select>
                </div>
            </div>
            <div class="col-md-5">
                <div class="comn-input-select">
                    <label for="first-name" class="form-label">first Name</label>
                    <input type="text" class="form-control" placeholder="First Name" id="first-name" name="first_name" value="{{$admin->first_name}}">
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="last-name" class="form-label">last Name</label>
                    <input type="text" class="form-control" placeholder="Last Name" id="last-name" name="last_name" value="{{$admin->last_name}}">
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="company-name" class="form-label">Company Name</label>
                    <input type="text" class="form-control" id="company-name" placeholder="Enter Company Name" name="company_name" value="{{$admin->company_name}}">
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="address" class="form-label">Street, house number:</label>
                    <input type="text" class="form-control" id="address" placeholder="Enter Your Address" name="address" value="{{$admin->address}}">
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="zip-code" class="form-label">Zip Code</label>
                    <input type="number" class="form-control" id="zip-code" placeholder="Enter Zip Code" name="zip_code" value="{{$admin->zip_code}}">
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="city" class="form-label">City</label>
                    <input type="text" class="form-control" id="city" placeholder="Enter City" name="city" value="{{$admin->city}}">
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="inputState" class="form-label">Country</label>
                   

                    <select id="inputState" class="form-select" name="state">
                        <option hidden>{{ __('messages.choose_country') }}</option>

                        @foreach(__('messages.countries') as $key => $label)
                            <option value="{{ $label }}" {{ old('state', $admin->state ?? '') === $label ? 'selected' : '' }}>
                                {{ $label }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="email-address" class="form-label">Email Address</label>
                    <input type="email" class="form-control" id="email-address" placeholder="Enter Email Address" name="email" value="{{$admin->email}}">
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="inputZip" class="form-label">Phone Number</label>
                    <div class="numer-input d-flex">
                    
                        <select name="country_code" class="form-select country_code_custom" required id="country_code">
                            <option value="">Select Code</option>
                            <option value="+49" data-image="https://flagcdn.com/16x12/de.png"  {{ $admin->country_code == '+49' ? 'selected' : '' }}>+49</option>
                            <option value="+43" data-image="https://flagcdn.com/16x12/at.png" {{ $admin->country_code == '+43' ? 'selected' : '' }}>+43</option>
                            <option value="+41"  data-image="https://flagcdn.com/16x12/ch.png" {{ $admin->country_code == '+41' ? 'selected' : '' }}>+41</option>
                        </select>
                            
                        <input type="text" class="form-control" id="inputZip" name="number" value="{{$admin->number}}">
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="tax-number" class="form-label">Tax Number</label>
                    <input type="text" class="form-control" id="tax-number" placeholder="Enter Tax Number" name="tax_number" value="{{$admin->tax_number}}">
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="umsatzsteuer" class="form-label">UMSt.-ID</label>
                    <input type="text" class="form-control" id="umsatzsteuer" placeholder="Enter umsatzsteuer" name="umsatzsteuer" value="{{$admin->umsatzsteuer}}" pattern="^.{11}$" title="UMSt.-ID should be exactly 11 characters." maxlength="11">
                </div>
            </div>


            <div class="col-md-6"></div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label class="form-label mb-0">Working Hours</label>
                </div>
                @php
                $days = ['mo' => 'Monday', 'di' => 'Tuesday', 'mi' => 'Wednesday', 'do' => 'Thursday', 'fr' => 'Friday', 'sa' => 'Saturday', 'so' => 'Sunday'];
            @endphp
            
            <div class="row">
                <div class="col-12">
                    <div class="comn-input-select date-from">
                        
                        @foreach ($days as $short => $full)
                        <div class="d-flex align-items-center mb-2 gap-2">
                            <p class="w-25">{{ $full }}</p>
                            <input type="time" class="form-control me-2" name="{{ $short }}_from" value="{{ $times[$loop->index]['open_time'] ?? '' }}">
                            <input type="time" class="form-control me-2" name="{{ $short }}_to" value="{{ $times[$loop->index]['close_time'] ?? '' }}">
                            <label class="form-check-label">
                                <input type="checkbox" name="day_closed[]" value="{{ $short }}" class="form-check-input">
                                Closed
                            </label>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
                <div class="col-12">
                    <div class="upper-main-btn-last-comn d-flex">
                        <button type="submit" class="add-user">Update profile</button>
                        <button class="cancel-btn"><a href="{{route('admin.profile')}}">Cancel</a></button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        const requiredFields = {
            title: 'Please select a title',
            first_name: 'Please enter first name',
            last_name: 'Please enter last name',
            company_name: 'Please enter company name',
            address: 'Please enter address',
            zip_code: 'Please enter zip code',
            city: 'Please enter city',
            state: 'Please select country',
            country_code: 'Please select country code',
            number: 'Please enter phone number',
            tax_number: 'Please enter tax number',
            umsatzsteuer: 'UMSt.-ID must be exactly 11 characters'
        };

        $.each(requiredFields, function(field, message) {
            $('[name="' + field + '"]').on('input blur', function() {
                validateField(field);
            });
        });

        $('form.validation').on('submit', function(e) {
            let isValid = true;
            $.each(requiredFields, function(field) {
                if (!validateField(field)) {
                    isValid = false;
                }
            });
            if (!isValid) {
                e.preventDefault();
            }
        });

        function validateField(name) {
            const $input = $('[name="' + name + '"]');
            const value = $input.val().trim();
            
            if (value.length === 0) {
                showError($input, requiredFields[name]);
                return false;
            }

            if (name === 'umsatzsteuer' && value.length !== 11) {
                showError($input, requiredFields[name]);
                return false;
            }

            clearError($input);
            return true;
        }

        function showError($input, message) {
            clearError($input);
            const $error = $('<small class="text-danger error-message">' + message + '</small>');
            $input.addClass('is-invalid').after($error);
        }

        function clearError($input) {
            $input.removeClass('is-invalid');
            $input.siblings('.error-message').remove();
        }
    });

    function previewImage(event) {
        const input = event.target;
        const file = input.files[0];
        const preview = document.getElementById('preview');

        if (file) {
            const validTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp', 'image/jpg'];
            
            if (!validTypes.includes(file.type)) {
                alert('Please select a valid image file (jpg, jpeg, png, gif, webp).');
                input.value = ''; // Clear file input
                preview.src = "{{ $admin->image ? asset('storage/'.$admin->image) : asset('admin/images/profile.png') }}";
                return;
            }

            const reader = new FileReader();
            reader.onload = function(e) {
                preview.src = e.target.result;
            };
            reader.readAsDataURL(file);
        }
    }
</script>

});
</script>
    <script>
      function formatFlag(option) {
          if (!option.id) return option.text;
          const imageUrl = $(option.element).data('image');
          const text = option.text;
          if (imageUrl) {
              return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
          }
          return text;
      }
  
      $(document).ready(function () {
          $('#country_code').select2({
              templateResult: formatFlag,
              templateSelection: formatFlag,
              minimumResultsForSearch: -1 
          });
      });
  </script>

@endsection