@extends('layouts.admin')
@section('content')
<style>
    .ck-editor__editable{
        height: 200px;
    }
</style>
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
    <div class="user-manage">
            <a href="{{ route('admin.blog.index') }}">Blog Management</a>
            <a class="" href="">Edit Blog</a>
            <a class="active" >{{$content->title}} </a>
        </div>
    </div>


    <div class="add-user-form">
        <form class="row g-3" action="{{route('admin.blog.update',[$content->id])}}" method="POST" id="content_manage" enctype="multipart/form-data">
            @csrf

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="inputtitle" class="form-label">Title</label>
                    <input type="text" class="form-control" name="title" id="title" value="{{$content->title ?? old('title')}}" placeholder="Enter Title" required>
                    @error('title') <small class="text-danger">{{ $message }}</small> @enderror
                </div>
            </div>

            <div class="col-md-12">
                <label for="image" class="form-label">Image</label>
                <div class="profile-pic">
                    <label class="-label" for="file">
                        <span class="glyphicon glyphicon-camera">
                            <i class="fas fa-camera"></i>
                        </span>
                    </label>
                    <input name="image" type="file" id="file" class="form-control" accept="image/*" onchange="previewImage(event)">
                    <figure class="profile-img">
                        <img id="preview" src="{{ asset('storage/'.$content->image) }}" alt="Profile Image">
                    </figure>
                </div>
                @error('image') <small class="text-danger">{{ $message }}</small> @enderror
            </div>

            <div class="col-md-12">
                <div class="comn-input-select">
                    <label for="description" class="form-label">Description</label>
                    <textarea class="form-control" id="description" name="description" required >{{$content->description ?? old('description') }}</textarea>
                    @error('description') <small class="text-danger">{{ $message }}</small> @enderror
                </div>
            </div>
            <div class="col-12">
                <div class="upper-main-btn-last-comn d-flex">
                    <button type="submit" class="add-user">Edit</button>
                    <button class="cancel-btn"><a href="{{route('admin.blog.index')}}">Cancel</a></button>
                </div>
            </div>
        </form>



    </div>
</div>
<script src="https://cdn.ckeditor.com/ckeditor5/38.1.0/classic/ckeditor.js"></script>
<script>
    ClassicEditor
        .create(document.querySelector('#description'),{
            height: 300 
        })
        .catch(error => {
            console.error(error);
        });
        function previewImage(event) {
        var reader = new FileReader();
        reader.onload = function() {
            var output = document.getElementById('preview');
            output.src = reader.result;
        }
        reader.readAsDataURL(event.target.files[0]);
    }
</script>
@endsection