@foreach($bookings as $booking)
<tr>
    <td>#{{ $booking->id }}</td>
    <td>
        @if($booking->userDetails)
            {{ $booking->userDetails->first_name }} {{ $booking->userDetails->last_name }}
        @else
            N/A
        @endif
    </td>
    <td>
        @if($booking->userDetails)
            {{ $booking->userDetails->phone }}
        @else
            N/A
        @endif
    </td>
    <td>
        @if($booking->userDetails)
            {{ $booking->userDetails->email }}
        @else
            N/A
        @endif
    </td>
    <td>
        @if($booking->items->isNotEmpty())
            {{ $booking->items->first()->pickup_date->format('d.m.Y') }} - 
            {{ $booking->items->first()->dropoff_date->format('d.m.Y') }}
        @else
            N/A
        @endif
    </td>
    <td>
        @if($booking->items->isNotEmpty())
            {{ $booking->items->first()->days }} Days
        @else
            N/A
        @endif
    </td>
    <td>
        <select class="form-select select-active-block" 
        id="statusSelect{{ $booking->id }}" 
        aria-label="Default select example">
    <option value="pending" {{ $booking->status == 'pending' ? 'selected' : '' }} data-previous-value="{{ $booking->status }}">pending</option>
    <option value="cancel" {{ $booking->status == 'cancel' ? 'selected' : '' }} data-previous-value="{{ $booking->status }}">cancel</option>
    <option value="confirmed" {{ $booking->status == 'confirmed' ? 'selected' : '' }} data-previous-value="{{ $booking->status }}">confirmed</option>
    <option value="completed" {{ $booking->status == 'completed' ? 'selected' : '' }} data-previous-value="{{ $booking->status }}">completed</option>
</select>
    </td>
    <td>
        <div class="upper-delete-btns d-flex">
            <a class="view-btn-eye" href="{{ route('admin.view.booking.detail', [$booking->id]) }}">
                <i class="fa-solid fa-eye"></i>
            </a>
            <a class="edit-btn-eye" href="{{ route('admin.edit.booking.detail', $booking->id) }}">
                <i class="fa-solid fa-pen-to-square"></i>
            </a>
        </div>
    </td>
</tr>
@endforeach