@extends('layouts.admin')
@section('content')
    <style>
        .checkout-validate {
            justify-content: flex-start;
        }

        .checkout-validate label p {
            font-size: 17px !important;
            line-height: 1 !important;
            margin-top: 4px !important;
        }
    </style>
    <main>
        <div class="col-9 main-dash-left">
        <section class="detail-show-all ">
            
                <div class="sub_heading_16">Billing Information</div>

                <div class="row row-gap-3 checkout_page_row">
                    <div class="col-lg-8">
                        @php
                            $user = session('guest_user');
                             
                        @endphp
                        <form action="{{ route('admin.checkout.submit') }}" method="POST" id="guest_checkout">
                            @csrf
                            <div class="row comm_form checkout_form_left">

                                <div class="col-md-12">
                                    <div class="inner-main-input inner-main-input2">
                                        <label class="form-label">Email</label>
                                        <input type="email" name="email" class="form-control"
                                            value="{{ old('email', $user->email ?? '') }}" placeholder="Enter email address"
                                            required>
                                    </div>

                                </div>

                                <div class="sub_heading_16">User details</div>

                                <div class="col-md-6">
                                    <div class="inner-main-input inner-main-input2">
                                        <label class="form-label">First Name</label>
                                        <input type="text" name="first_name" class="form-control"
                                            value="{{ old('first_name', $user->first_name ?? '') }}"
                                            placeholder="Enter first name" required>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="inner-main-input inner-main-input2">
                                        <label class="form-label">Surname</label>
                                        <input type="text" name="last_name" class="form-control"
                                            value="{{ old('last_name', $user->last_name ?? '') }}"
                                            placeholder="Enter surname" required>
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="inner-main-input inner-main-input2">
                                        <label class="form-label">Company Name (Optional)</label>
                                        <input type="text" name="company_name" class="form-control"
                                            value="{{ old('company_name', $user->company_name ?? '') }}"
                                            placeholder="Enter company name">
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="inner-main-input inner-main-input2">
                                        <label class="form-label">Street, House Number</label>
                                        <input type="text" name="address" class="form-control"
                                            value="{{ old('address', $formValues['address'] ?? '') }}"
                                            placeholder="Enter your address" required>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="inner-main-input inner-main-input2">
                                        <label class="form-label">Zip Code</label>
                                        <input type="text" name="zip" class="form-control"
                                            value="{{ old('zip', $formValues['zip'] ?? '') }}" placeholder="Enter Zip Code"
                                            required>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="inner-main-input inner-main-input2">
                                        <label class="form-label">City</label>
                                        <input type="text" name="city" class="form-control"
                                            value="{{ old('city',  $formValues['city'] ?? '') }}" placeholder="City" required>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="inner-main-input inner-main-input2">
                                        <label class="form-label">Region/State</label>
                                         <select class="form-select" name="region">
                                            <option value="">{{ __('messages.select_region') }}</option>

                                            @foreach(__('messages.region') as $key => $value)
                                                <option value="{{ $key }}"
                                                    {{ old('region', $formValues['region'] ?? '') == $key ? 'selected' : '' }}>
                                                    {{ $value }}
                                                </option>
                                            @endforeach
                                        </select>

                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="d-flex profile_title_input">
                                        <div class="inner-main-input inner-main-input2 title_inpt">
                                            <label class="form-label">Phone Code</label>
                                            <select class="form-select" name="phone_code" id="phone_code">
                                                <option value="+49" data-image="https://flagcdn.com/16x12/de.png"
                                                    {{ old('phone_code', $formValues['phone_code'] ?? '') == '+49' ? 'selected' : '' }}>
                                                    +49</option>
                                                <option value="+41" data-image="https://flagcdn.com/16x12/ch.png"
                                                    {{ old('phone_code', $formValues['phone_code'] ?? '') == '+41' ? 'selected' : '' }}>
                                                    +41</option>
                                                <option value="+43"
                                                    data-image="https://flagcdn.com/16x12/at.png"{{ old('phone_code', $formValues['phone_code'] ?? '') == '+43' ? 'selected' : '' }}>
                                                    +43</option>
                                            </select>
                                        </div>
                                        <div class="inner-main-input inner-main-input2">
                                            <label class="form-label disapear">Phone Number</label>
                                            <input type="tel" name="phone_number" class="form-control"
                                                value="{{ old('phone_number', $formValues['phone_number'] ?? '') }}"
                                                placeholder="Phone Number" required>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex form-check checkout_email_check checkout-validate ">
                                <input class="form-check-input" type="checkbox" name="create_customer"
                                    id="create_customer">
                                <label class="form-check-label" for="gridCheck2">
                                    <p class="default_text">Create Customer Account</p>
                                </label>
                            </div>






                    </div>
                    <div class="col-lg-4">
                        <div class="cart_total_right_col">
                            <div class="sub_heading_18">Card Totals</div>
                            <div class="d-flex comm_detail_list_view cart_total_list">
                                <div class="comm_detail_list_col">
                                    <h5>Subtotal</h5>
                                    <h6>{{ number_format($subtotal, 2, ',', '') }} €</h6>
                                </div>
                                <div class="comm_detail_list_col">
                                    <h5>Discount</h5>
                                    <h6>{{ number_format($discount, 2, ',', '') }} €</h6>
                                </div>
                                <div class="comm_detail_list_col">
                                    <h5>Net Price</h5>
                                    <h6>{{ number_format($netPrice, 2, ',', '') }} €</h6>
                                </div>
                                <div class="comm_detail_list_col">
                                    <h5>Net Price Insurance</h5>
                                    <h6>{{ number_format($insuranceTotal, 2, ',', '') }} €</h6>
                                </div>
                                <div class="comm_detail_list_col">
                                    <h5>Tax (19%)</h5>
                                    <h6>{{ number_format($tax, 2, ',', '') }} €</h6>
                                </div>
                                <div class="comm_detail_list_col bott_total_row">
                                    <h5>Total</h5>
                                    <h6>{{ number_format($total, 2, ',', '') }} €</h6>
                                </div>
                            </div>

                            <button type="submit" class="btn primary-btn primary-btn2 w-100 mt-3">Send Paymemt Link</button>

                        </div>
                    </div>
                </div>
                </form>
           
        </section>
        </div>
    </main>
@endsection
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script>
    $(document).ready(function() {
        $("#calendar-box").datepicker({});
    });

    // date input js

    document.addEventListener("DOMContentLoaded", function() {
        const dateInputs = document.querySelectorAll(".date-input");

        dateInputs.forEach((input) => {
            input.addEventListener("click", function() {
                this.showPicker();
            });
        });
    });
</script>

<script>
    $(document).ready(function() {

        $('input[name="email"], input[name="first_name"], input[name="last_name"], input[name="company_name"], input[name="address"], input[name="zip"], input[name="city"], select[name="region"], select[name="phone_code"], input[name="phone_number"]')
            .on('change input', function() {
                const name = $(this).attr('name');
                const value = $(this).val();

                $('input[type="hidden"][name="' + name + '"]').val(value);
            });


        $('input[name="payment_method"]').change(function() {
            $('#selected_payment_method').val($(this).val());
        });

        $('#guest_checkout').submit(function(e) {
            e.preventDefault();

            if (!validateForm()) {
                return false;
            }

            $(this).find('button[type="submit"]').prop('disabled', true).html('Processing...');

            this.submit();
        });

        function validateForm() {
            let isValid = true;
            $('.is-invalid').removeClass('is-invalid');
            $('.invalid-feedback').remove();

            const requiredFields = [
                'email', 'first_name', 'last_name', 'address',
                'zip', 'city', 'phone_number'
            ];

            requiredFields.forEach(field => {
                if (!$(`[name="${field}"]`).val()) {
                    $(`[name="${field}"]`).addClass('is-invalid')
                        .after(`<div class="invalid-feedback">This field is required</div>`);
                    isValid = false;
                }
            });

            const email = $('[name="email"]').val();
            if (email && !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email)) {
                $('[name="email"]').addClass('is-invalid')
                    .after(`<div class="invalid-feedback">Please enter a valid email</div>`);
                isValid = false;
            }

            if (!isValid) {
                $('html, body').animate({
                    scrollTop: $('.is-invalid').first().offset().top - 100
                }, 500);
            }

            return isValid;
        }
    });
</script>
<script>
    function formatFlag(option) {
        if (!option.id) return option.text;
        const imageUrl = $(option.element).data('image');
        const text = option.text;
        if (imageUrl) {
            return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
        }
        return text;
    }

    $(document).ready(function() {
        $('#phone_code').select2({
            templateResult: formatFlag,
            templateSelection: formatFlag,
            minimumResultsForSearch: -1
        });
    });
</script>
