@extends('layouts.admin')
@section('content')

<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="{{ route('admin.bundle.index') }}">Bundle Management</a>
            <a class="active">Edit Bundle</a>
        </div>
    </div>

    <div class="add-user-form">
        <h3>Edit Bundle</h3>
        <form class="row g-3" method="Post" action="{{route('admin.bundle.update',$bundle)}}" id="bundleForm">
            @csrf
            @method('PUT')

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="bundle_name" class="form-label">Bundle Name</label>
                    <input type="text" class="form-control" id="bundle_name" name="bundle_name" value="{{ old('bundle_name', $bundle->bundle_name) }}">
                    <span class="error-message" id="bundle_name-error"></span>
                </div>
                @error('bundle_name')
                <div class="text-danger error mt-1">{{ $message }}</div>
            @enderror
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="category" class="form-label">Product Category</label>
                    <input type="text" class="form-control" id="category" name="product_category" value="{{ old('product_category', $bundle->product_category) }}">
                    <span class="error-message" id="category-error"></span>
                </div>
                @error('category')
                <div class="text-danger error mt-1">{{ $message }}</div>
            @enderror
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="rooftype_eng" class="form-label">Roof Type</label>
                    <input type="text" class="form-control" id="rooftype_eng" name="rooftype_eng" value="{{ old('rooftype_eng', $bundle->rooftype_eng) }}">
                    <span class="error-message" id="rooftype_eng-error"></span>
                </div>
                @error('rooftype_eng')
                <div class="text-danger error mt-1">{{ $message }}</div>
            @enderror
            </div>

            {{-- <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="rooftype_ger" class="form-label">Roof Type (German)</label>
                    <input type="text" class="form-control" id="rooftype_ger" name="rooftype_ger" value="{{ old('rooftype_ger', $bundle->rooftype_ger) }}">
                    <span class="error-message" id="rooftype_ger-error"></span>
                </div>
                @error('rooftype_ger')
                <div class="text-danger error mt-1">{{ $message }}</div>
            @enderror
            </div> --}}

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="carrier_length" class="form-label">Carrier SKU</label>
                    <input type="text" class="form-control" id="carrier_length" name="carrier_length" value="{{ old('carrier_length', $bundle->carrier_length) }}">
                    <span class="error-message" id="carrier_length-error"></span>
                </div>
                @error('carrier_length')
                <div class="text-danger error mt-1">{{ $message }}</div>
            @enderror
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="foot_sku" class="form-label">Foot SKU</label>
                    <input type="text" class="form-control" id="foot_sku" name="foot_sku" value="{{ old('foot_sku', $bundle->foot_sku) }}">
                    <span class="error-message" id="foot_sku-error"></span>
                </div>
                @error('foot_sku')
                <div class="text-danger error mt-1">{{ $message }}</div>
            @enderror
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="footkit_sku" class="form-label">FootKit SKU</label>
                    <input type="text" class="form-control" id="footkit_sku" name="footkit_sku" value="{{ old('footkit_sku', $bundle->footkit_sku) }}">
                    <span class="error-message" id="footkit_sku-error"></span>
                </div>
                @error('footkit_sku')
                <div class="text-danger error mt-1">{{ $message }}</div>
            @enderror
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="car_make" class="form-label">Car Make</label>
                    <input type="text" class="form-control" id="car_make" name="car_make" value="{{ old('car_make', $bundle->car_make) }}">
                    <span class="error-message" id="car_make-error"></span>
                </div>
                @error('car_make')
                <div class="text-danger error mt-1">{{ $message }}</div>
            @enderror
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="model" class="form-label">Model</label>
                    <input type="text" class="form-control" id="model" name="model" value="{{ old('model', $bundle->model) }}">
                    <span class="error-message" id="model-error"></span>
                </div>
                @error('model')
                <div class="text-danger error mt-1">{{ $message }}</div>
            @enderror
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="type_year" class="form-label">Type/Year</label>
                    <input type="text" class="form-control" id="type_year" name="type_year" value="{{ old('type_year', $bundle->type_year) }}">
                    <span class="error-message" id="type_year-error"></span>
                </div>
                @error('type_year')
                <div class="text-danger error mt-1">{{ $message }}</div>
            @enderror
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="recommended_roofbox_size" class="form-label">Recommended Roofbox Size</label>
                    <input type="text" class="form-control" id="recommended_roofbox_size" name="recommended_roofbox_size" value="{{ old('recommended_roofbox_size', $bundle->recommended_roofbox_size) }}">
                    <span class="error-message" id="recommended_roofbox_size-error"></span>
                </div>
                @error('recommended_roofbox_size')
                <div class="text-danger error mt-1">{{ $message }}</div>
            @enderror
            </div>

            <div class="col-md-12">
                <div class="comn-input-select">
                    <label for="description" class="form-label">Description</label>
                    <textarea class="form-control" id="description" name="description">{{ old('description', $bundle->description) }}</textarea>
                    <span class="error-message" id="description-error"></span>
                </div>
                @error('description')
                <div class="text-danger error mt-1">{{ $message }}</div>
            @enderror
            </div>

            <div class="col-12">
                <div class="upper-main-btn-last-comn d-flex">
                    <button type="submit" class="add-user">Save Changes</button>
                    <button class="cancel-btn"><a href="{{route('admin.bundle.index')}}">Cancel</a></button>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const form = document.getElementById('bundleForm');
    const inputs = form.querySelectorAll('input, textarea');

    inputs.forEach(input => {
        input.addEventListener('input', function () {
            validateField(input);
        });
    });

    function validateField(input) {
        const value = input.value.trim();
        const name = input.name;
        let errorMessage = '';

        if (value === '') {
            switch (name) {
                case 'bundle_name':
                    errorMessage = 'Please enter bundle name.';
                    break;
                case 'category':
                    errorMessage = 'Please enter product category.';
                    break;
                case 'rooftype_eng':
                    errorMessage = 'Please enter roof type (English).';
                    break;
                case 'rooftype_ger':
                    errorMessage = 'Please enter roof type (German).';
                    break;
                case 'carrier_length':
                    errorMessage = 'Please enter carrier SKU.';
                    break;
                case 'foot_sku':
                    errorMessage = 'Please enter foot SKU.';
                    break;
                case 'footkit_sku':
                    errorMessage = 'Please enter footkit SKU.';
                    break;
                case 'car_make':
                    errorMessage = 'Please enter car make.';
                    break;
                case 'model':
                    errorMessage = 'Please enter model.';
                    break;
                case 'type_year':
                    errorMessage = 'Please enter type/year.';
                    break;
            }
        }

        if (name === 'bundle_name' && value.length > 100) {
            errorMessage = 'Bundle name must not exceed 100 characters.';
        }

        if ((name === 'foot_sku' || name === 'footkit_sku' || name === 'carrier_length') && value.length > 50) {
            errorMessage = 'SKU must not exceed 50 characters.';
        }

        const errorElement = document.getElementById(`${name}-error`);
        if (errorElement) {
            errorElement.textContent = errorMessage;
        }

        input.classList.toggle('is-invalid', !!errorMessage);
        return !errorMessage;
    }

    form.addEventListener('submit', function (e) {
        let isValid = true;

        inputs.forEach(input => {
            if (!validateField(input)) {
                isValid = false;
            }
        });

        if (!isValid) {
            e.preventDefault();
        }
    });
});
</script>
@endsection