<!DOCTYPE html>
<html>
<head>
    <title>Bundles Report</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0;
            padding: 0;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            font-size: 12px; /* Reduce font size for fitting */
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 6px; /* Reduce padding */
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        @page {
            size: landscape; /* Set the page size to landscape */
            margin: 10mm; /* Adjust margin if needed */
        }
    </style>
</head>
<body>
    <h1>Bundles Report</h1>
    <table>
        <thead>
            <tr>
                <th>Bundle ID</th>
                <th>Bundle Name</th>
                <th>Product Category</th>
                <th>Roof Type</th>
                <th>Carrier SKU</th>
                <th>Foot SKU</th>
                <th>FootKit SKU</th>
            </tr>
        </thead>
        <tbody>
            @foreach($bundles as $bundle)
            <tr>
                <td>#{{ $bundle->id }}</td>
                <td>{{ $bundle->bundle_name }}</td>
                <td>{{ $bundle->category }}</td>
                <td>{{ $bundle->rooftype_eng }}</td>
                <td>{{ $bundle->carrier_length }}</td>
                <td>{{ $bundle->foot_sku }}</td>
                <td>{{ $bundle->footkit_sku }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>