@forelse($bookings as $booking)
@foreach($booking->items as $item)
@if(!$item->related_item)

    <tr>
        <td>
            @if($item->vendor_id)
                <span class="text-secondary me-1" title="Includes vendor items">
                    <i class="fa-solid fa-flag"></i>
                </span>
            @endif
            {{ $item->booking_id ?? 'N/A' }}
            
             @if($item->user_timing)
                <span class="text-primary me-1" title="Customer requested timing change">
                    <i class="fa-solid fa-flag"></i>
                </span>
            @endif

            @if($booking->delay || $item->damage)
                <span class="text-danger me-1" title="Delay or Damage reported">
                    <i class="fa-solid fa-flag"></i>
                </span>
            @endif
        </td>
       
        <td>{{ $booking->userDetails->first_name . ' ' . $booking->userDetails->last_name ?? 'N/A' }}</td>
        <td>{{ preg_replace('/^(\+\d{0,2})(\d+)/', '$1 $2', $booking->userDetails->phone) ?? 'N/A' }}</td>
        <td>{{$booking->userDetails->email}}</td>
        <td>{{ $activityCounts[$booking->id] ?? 0 }}</td>
        <td>
            @php
                $reasons = \App\Models\ActivityLog::where('action', 'appointment_change')
                        ->where('description', 'like', '%booking #' . $booking->id . '%')
                        ->orderByDesc('created_at')
                        ->pluck('details');


            @endphp
            
    
            @if ($reasons->isNotEmpty())
                {!! $reasons->map(fn($r) => e($r))->implode(' / ') !!}
            @else
                -
            @endif
        </td>
        <td>
            {{ $item->pickup_date ? \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') : '-' }} /
            {{ $item->pickup_time ? \Carbon\Carbon::parse($item->pickup_time)->format('H:i') : '-' }}
        </td>
        <td>
            {{ $item->dropoff_date ? \Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y') : '-' }} /
            {{ $item->dropoff_time ? \Carbon\Carbon::parse($item->dropoff_time)->format('H:i') : '-' }}
        </td>
        <td>
            {{ $item->new_dropoff_date ? \Carbon\Carbon::parse($item->new_dropoff_date)->format('d.m.Y') : '-' }} /
            {{ $item->new_dropoff_time ? \Carbon\Carbon::parse($item->new_dropoff_time)->format('H:i') : '-' }}
        </td>
        
        <td>
            <div class="upper-delete-btns d-flex">
                <a class="view-btn-eye" href="{{ route('admin.view.booking.detail', [$booking->id]) }}">
                    <i class="fa-solid fa-eye"></i>
                </a>
                <a class="edit-btn-eye" href="{{ route('admin.edit.booking.detail', $booking->id) }}">
                    <i class="fa-solid fa-pen-to-square"></i>
                </a>
            </div>
        </td>
        <td>
            <select class="form-select select-active-block" 
            id="statusSelect{{ $booking->id }}" 
            aria-label="Default select example" data-current-status="{{$booking->status}}"  {{ $booking->refund_amount ? 'disabled' : '' }} disabled>
                <option value="pending" class="pending-op" {{ $booking->status == 'pending' ? 'selected' : '' }} data-previous-value="{{ $booking->status }}">pending</option>
                <option value="cancelled" class="cancel-op" {{ $booking->status == 'cancelled' ? 'selected' : '' }} data-previous-value="{{ $booking->status }}">Cancelled</option>
                <option value="confirmed" class="confirmed-op" {{ $booking->status == 'confirmed' ? 'selected' : '' }} data-previous-value="{{ $booking->status }}">confirmed</option>
                <option value="completed" class="completed-op"  {{ $booking->status == 'completed' ? 'selected' : '' }} data-previous-value="{{ $booking->status }}">completed</option>
            </select>
        </td>
    </tr>
    @endif
    @endforeach
@empty
<tr>
    <td colspan="7" class="text-center">No bookings found for selected date</td>
</tr>
@endforelse
