<!DOCTYPE html>
<html>
<head>
    <title>Bookings for {{ $date }}</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0;
            padding: 0;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            font-size: 12px; /* Reduce font size for fitting */
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 6px; /* Reduce padding */
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        @page {
            size: landscape; /* Set the page size to landscape */
            margin: 10mm; /* Adjust margin if needed */
        }
    </style>
</head>
<body>
    <h1>Calendar Report for {{ \Carbon\Carbon::parse($date)->format('F j, Y') }}</h1>
    
    <table>
        <thead>
            <tr>
                <th>Booking ID</th>
                <th>Client Name</th>
                <th>Email</th>
                <th>Phone Number</th>
                <th>No. Of Times Changed</th>
                <th>Reason</th>
                <th>Pick-Up Date/Time</th>
                <th>Drop-Off Date/Time</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @forelse($bookings as $booking)
                @foreach($booking->items as $item)
                    @if(!$item->related_item)
                    <tr>
                        <td>{{ $booking->id }}</td>
                        <td>{{ $booking->userDetails->first_name ?? '' }} {{ $booking->userDetails->last_name ?? '' }}</td>
                        <td>{{ $booking->userDetails->email ?? '' }}</td>
                        <td> {{ preg_replace('/^(\+\d{0,2})(\d+)/', '$1 $2', $booking->userDetails->phone) }}</td>
                        <td>{{ $activityCounts[$booking->id] ?? 0 }}</td>
                        <td>
                            @php
                                $reasons = \App\Models\ActivityLog::where('action', 'appointment_change')
                                    ->where('description', 'like', '%booking #' . $booking->id . '%')
                                    ->orderByDesc('created_at')
                                    ->pluck('details');
                            @endphp

                            @if ($reasons->isNotEmpty())
                                {!! $reasons->map(fn($r) => e($r))->implode('<br>') !!}
                            @else
                                -
                            @endif
                        </td>
                        <td>
                            {{ $item->pickup_date ? \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') : '-' }} /
                            {{ $item->pickup_time ? \Carbon\Carbon::parse($item->pickup_time)->format('H:i') : '-' }}
                        </td>
                        <td>
                            {{ $item->dropoff_date ? \Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y') : '-' }} /
                            {{ $item->dropoff_time ? \Carbon\Carbon::parse($item->dropoff_time)->format('H:i') : '-' }}
                        </td>
                        <td>{{ ucfirst($booking->status) }}</td>
                    </tr>
                    @endif
                @endforeach
            @empty
                <tr>
                    <td colspan="8">No bookings found</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</body>
</html>