@extends('layouts.admin')
@section('content')
<link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet" />
<style>
    .ck-editor__editable {
        height: 200px;
    }
</style>
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="{{ route('admin.content.index') }}">Add Category</a>
            <a class="active">Add</a>
        </div>
    </div>

    <div class="add-user-form">
        <form class="row g-3" action="{{ route('admin.category.add') }}" method="POST" id="content_manage">
            @csrf

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="name" class="form-label">Category Name</label>
                    <input type="text" class="form-control" name="name" id="name" value="{{ old('name') }}" placeholder="Enter Category Name">
                    @error('name') <small class="text-danger">{{ $message }}</small> @enderror
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="color_ids" class="form-label">Colors</label>
                    <select name="color_ids[]" class="form-control select2" multiple>
                        @foreach($colors as $color)
                            <option value="{{ $color->id }}">{{ $color->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="size_ids" class="form-label">Sizes</label>
                    <select name="size_ids[]" class="form-control select2" multiple>
                        @foreach($sizes as $size)
                            <option value="{{ $size->id }}">{{ $size->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="variation_ids" class="form-label">Variations</label>
                    <select name="variation_ids[]" class="form-control select2" multiple>
                        @foreach($variations as $variation)
                            <option value="{{ $variation->id }}">{{ $variation->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="col-12">
                <div class="upper-main-btn-last-comn d-flex">
                    <button type="submit" class="add-user">Add</button>
                    <button class="cancel-btn"><a href="{{ route('admin.category.index') }}">Cancel</a></button>
                </div>
            </div>
        </form>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    $(document).ready(function() {
        $('.select2').select2({
            placeholder: "Select options"
        });
    });
</script>
@endsection
