@extends('layouts.admin')
@section('content')
<link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet" />
<style>
    .ck-editor__editable {
        height: 200px;
    }
    .select2-container--default .select2-selection--multiple {
        padding: 0.7rem 1.4rem !important;
        height: auto !important; 
    }
</style>
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="{{ route('admin.content.index') }}">Category management</a>
            <a class="active">Edit</a>
        </div>
    </div>

    <div class="add-user-form">
        <form class="row g-3" action="{{ route('admin.category.update', [$category->slug]) }}" method="POST" id="content_manage">
            @csrf

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="inputname" class="form-label">Name</label>
                    <input type="text" class="form-control" name="name" id="name" value="{{ old('name', $category->name) }}" placeholder="Enter Category Name">
                    @error('name') <small class="text-danger">{{ $message }}</small> @enderror
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="color_ids" class="form-label">Colors</label>
                    <select name="color_ids[]" class="form-control select2" multiple>
                        @foreach($colors as $color)
                            <option value="{{ $color->id }}" {{ in_array($color->id, $category->color_ids ?? []) ? 'selected' : '' }}>{{ $color->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="size_ids" class="form-label">Sizes</label>
                    <select name="size_ids[]" class="form-control select2" multiple>
                        @foreach($sizes as $size)
                            <option value="{{ $size->id }}" {{ in_array($size->id, $category->size_ids ?? []) ? 'selected' : '' }}>{{ $size->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="variation_ids" class="form-label">Variations</label>
                    <select name="variation_ids[]" class="form-control select2 fav_clr" multiple>
                        <option value="all">all</option>
                        @foreach($variations as $variation)
                            <option value="{{ $variation->id }}" {{ in_array($variation->id, $category->variation_ids ?? []) ? 'selected' : '' }}>{{ $variation->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            
            <div class="col-12">
                <div class="upper-main-btn-last-comn d-flex">
                    <button type="submit" class="add-user">Save Changes</button>
                    <button class="cancel-btn"><a href="{{ route('admin.category.index') }}">Cancel</a></button>
                </div>
            </div>
        </form>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>


$(document).ready(function () {
    $('.select2').select2({
        placeholder: "Select options"
    });

    $('.fav_clr').on("select2:select", function (e) { 
         const $select = $(this);
           var data = e.params.data.text;
           if(data=='all'){
            $(".fav_clr > option").prop("selected","selected");
            $select.find('option[value="all"]').prop("selected", false);
            $(".fav_clr").trigger("change");
           }
      });


});


</script>
@endsection
