@extends('layouts.admin')
@section('content')
<style>
    .ck-editor__editable{
        height: 200px;
    }
</style>
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="{{route('admin.content.index')}}">Content management</a>
            <a class="active">Add</a>
        </div>
    </div>


    <div class="add-user-form">
        <form class="row g-3" action="{{route('admin.content.store')}}" method="POST" id="content_manage">
            @csrf

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="inputtitle" class="form-label">Title</label>
                    <input type="text" class="form-control" name="title" id="title" value="{{ old('title') }}" placeholder="Enter Title">
                    @error('title') <small class="text-danger">{{ $message }}</small> @enderror
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="slug" class="form-label">Slug</label>
                    <input type="text" class="form-control" readonly name="slug" id="slug" value="{{ old('slug') }}" placeholder="Slug">
                    @error('slug') <small class="text-danger">{{ $message }}</small> @enderror
                </div>
            </div>

            <div class="col-md-12">
                <div class="comn-input-select">
                    <label for="description" class="form-label">Description</label>
                    <textarea class="form-control" id="description" name="description" >{{ old('description') }}</textarea>
                    @error('description') <small class="text-danger">{{ $message }}</small> @enderror
                </div>
            </div>

            <!-- <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="meta_title" class="form-label">Meta Title</label>
                    <input type="text" class="form-control" id="meta_title" name="meta_title" value="{{ old('meta_title') }}" placeholder="Enter Meta Title">
                    @error('meta_title') <small class="text-danger">{{ $message }}</small> @enderror
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="meta_keyword" class="form-label">Meta Keyword</label>
                    <input type="text" class="form-control" id="meta_keyword" placeholder="Enter Meta Keywords" value="{{ old('meta_keyword') }}" name="meta_keyword">
                    @error('meta_keyword') <small class="text-danger">{{ $message }}</small> @enderror
                </div>
            </div>

            <div class="col-md-12">
                <div class="comn-input-select">
                    <label for="meta-description" class="form-label">Meat Description</label>
                    <textarea class="form-control " id="meta-description" name="meta_description" rows="5">{{ old('meta_description') }}</textarea>
                    @error('meta_description') <small class="text-danger">{{ $message }}</small> @enderror
                </div>
            </div> -->

            <div class="col-12">
                <div class="upper-main-btn-last-comn d-flex">
                    <button type="submit" class="add-user">Add</button>
                    <button class="cancel-btn"><a href="{{route('admin.content.index')}}">Cancel</a></button>
                    <!-- <button type="reset" class="cancel-btn">Cancel</button> -->
                </div>
            </div>
        </form>



    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.ckeditor.com/ckeditor5/38.1.0/classic/ckeditor.js"></script>
<script>
    ClassicEditor
        .create(document.querySelector('#description'),{
            height: 300 
        })
        .catch(error => {
            console.error(error);
        });
        $('#title').on('input', function() {
        var title = $(this).val();
        var slug = title.toLowerCase().replace(/[^a-z0-9-]+/g, '-').replace(/^-+|-+$/g, '');
        $('#slug').val(slug);
    });
</script>
@endsection

<!-- <script>
   

    $("#content_manage").validate({
        rules: {
            title: {
                required: true,
                noSpace: true,

            },
            description: {
                required: true,
                noSpace: true,
            },

        },
        messages: {
            title: {
                required: "Title is required.",


            },
            description: {
                required: "Description is required.",


            },

        },
        submitHandler: function(form) {

            form.submit();
        },
        errorElement: 'span',
        errorPlacement: function(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.text-err').append(error);
        },
        highlight: function(element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function(element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });
</script> -->