@extends('layouts.admin')
@section('content')
<style>
    .ck-editor__editable{
        height: 200px;
    }
</style>
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="{{route('admin.content.index')}}">Content management</a>
            <a class="">Edit</a>
            <a class="active"> {{$content->title}} </a>
        </div>
    </div>


    <div class="add-user-form">
        <form class="row g-3" action="{{route('admin.content.update',[$content->id])}}" method="POST" id="content_manage">
            @csrf

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="inputtitle" class="form-label">Title</label>
                    <input type="text" class="form-control" name="title" id="title" value="{{$content->title ?? old('title')}}" placeholder="Enter Title">
                    @error('title') <small class="text-danger">{{ $message }}</small> @enderror
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="slug" class="form-label">Slug</label>
                    <input type="text" class="form-control" readonly name="slug" id="slug" value="{{$content->slug}}" placeholder="Slug">
                    @error('slug') <small class="text-danger">{{ $message }}</small> @enderror
                </div>
            </div>

            <div class="col-md-12">
                <div class="comn-input-select">
                    <label for="description" class="form-label">Description</label>
                    <textarea class="form-control" id="description" name="description" >{{$content->description ?? old('description') }}</textarea>
                    @error('description') <small class="text-danger">{{ $message }}</small> @enderror
                </div>
            </div>

           
            <div class="col-md-12">
                <div class="comn-input-select">
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="is_header" id="is_header" {{ GetMetaData('is_header',$content->slug) == "1" ? "checked" :"" }} value="1">
                        <label class="form-check-label" for="is_header">Header</label>
                      </div>
                      <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="is_footer" id="is_footer" value="1" {{ GetMetaData('is_footer',$content->slug) == "1" ? "checked" :"" }}>
                        <label class="form-check-label" for="is_footer">Footer</label>
                      </div>
                </div>
            </div>
            <div class="col-12">
                <div class="upper-main-btn-last-comn d-flex">
                    <button type="submit" class="add-user">Save</button>
                    <button class="cancel-btn"><a href="{{route('admin.content.index')}}">Cancel</a></button>

                </div>
            </div>
        </form>



    </div>
</div>
<script src="https://cdn.ckeditor.com/ckeditor5/38.1.0/classic/ckeditor.js"></script>
<script>
    ClassicEditor
        .create(document.querySelector('#description'),{
            height: 300 
        })
        .catch(error => {
            console.error(error);
        });
</script>
@endsection

<!-- <script>
    $('#title').on('input', function() {
        var title = $(this).val();
        var slug = title.toLowerCase().replace(/[^a-z0-9-]+/g, '-').replace(/^-+|-+$/g, '');
        $('#slug').val(slug);
    });

    $("#content_manage").validate({
        rules: {
            title: {
                required: true,
                noSpace: true,

            },
            description: {
                required: true,
                noSpace: true,
            },

        },
        messages: {
            title: {
                required: "Title is required.",


            },
            description: {
                required: "Description is required.",


            },

        },
        submitHandler: function(form) {

            form.submit();
        },
        errorElement: 'span',
        errorPlacement: function(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.text-err').append(error);
        },
        highlight: function(element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function(element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });
</script> -->