@extends('layouts.admin')

@section('content')

<style>
    .bg-purple{
        background-color : purple !important;
    }
    .cs-pagination span svg {
        width: 10px;
        height: 10px;
    }
    .bg-pink{
        background-color : #e83e8c !important;
    }
    .bg-darkGreen{
        background-color :rgb(4, 100, 1)
    }
</style>
<div class="col-9 main-dash-left">
    <div class="notification-block">
        <div class="d-flex justify-content-between align-items-center mb-3 noti-inner">
            <h4 class="mb-0">@lang('messages.ui.all_notifications')</h4>
            @if($notifications->where('is_read', false)->count() > 0)
                <form action="{{ route('admin.notifications.read.all') }}" method="POST">
                    @csrf
                    <button type="submit" class="noti-btn">
                        <i class="fas fa-check-circle me-1"></i> @lang('messages.ui.mark_all_read')
                    </button>
                </form>
            @endif
        </div>

        @if($notifications->isEmpty())
            <p class="text-muted">@lang('messages.ui.no_notifications')</p>
        @else
        <div class="mb-3 d-flex justify-content-between align-items-center">
            <div class="d-flex w-100">
                <input type="text" id="searchNotifications" 
                    class="form-control form-control-lg me-3 flex-grow-1"
                    placeholder="@lang('messages.ui.search_placeholder')">
        
                    <form method="GET" action="{{ route('admin.notifications.page') }}" class="flex-shrink-0" style="min-width: 250px;">
                        <select name="type" class="form-select form-select-lg" onchange="this.form.submit()">
                            <option value="">@lang('messages.ui.filter')</option>
                            @foreach($types as $type)
                            @php
                                $displayType = trans('messages.types.' . $type);
                                // Fallback if translation not found
                                if ($displayType === 'messages.types.' . $type) {
                                    $displayType = str_replace('_', ' ', $type);
                                    $displayType = \Illuminate\Support\Str::title($displayType);
                                    $displayType = preg_replace('/\bSpo\b/', 'SPO', $displayType);
                                }
                            @endphp
                            <option value="{{ $type }}" {{ request('type') == $type ? 'selected' : '' }}>
                                {{ $displayType }}
                            </option>
                        @endforeach
                        </select>
                    </form>
                    
            </div>
        </div>
        
        <!-- Add a no results message element -->
        <div id="noResults" class="alert alert-info d-none">
            @lang('messages.ui.no_results')
        </div>
        
            <ul class="list-group" id="notificationList">
                @foreach($notifications as $notification)
                    <li class="list-group-item d-flex notification-item justify-content-between align-items-start {{ $notification->is_read ? '' : 'fw-bold bg-light' }}">
                        <div class="flex-grow-1">
                            <div class="d-flex justify-content-between align-items-center bk-title">
                                @php
                                    // Badge classes
                                    switch ($notification->type) {
                                        case 'new_query':
                                        case 'new_Query':
                                            $badgeClass = 'bg-info'; 
                                            break;
                                        case 'booking_cancellation':
                                            $badgeClass = 'bg-danger'; 
                                            break;
                                        case 'max_voucher_limit_exceed':
                                            $badgeClass = 'bg-warning text-dark'; 
                                            break;
                                        case 'preferred_timings':
                                        case 'Preferred Timings':
                                            $badgeClass = 'bg-primary';
                                            break;
                                        case 'spo_product_request':
                                            $badgeClass = 'bg-warning'; 
                                            break;
                                        case 'payment_link_paid':
                                            $badgeClass = 'bg-dark';
                                            break;
                                        case 'new_booking_request':
                                            $badgeClass = 'bg-purple';
                                            break;
                                        case 'new_SPO_registration':
                                            $badgeClass = 'bg-success';
                                            break;
                                        case 'user_slot_change_request':
                                            $badgeClass = 'bg-pink';
                                            break;
                                        case 'SPO_product_enable':
                                        case 'SPO_product_administration':
                                            $badgeClass = 'bg-darkGreen';
                                            break;
                                        case 'payment_link_expired':
                                            $badgeClass = 'bg-danger';
                                            break;
                                        case 'voucher_expired':
                                            $badgeClass = 'bg-warning text-dark';
                                            break;
                                        default:
                                            $badgeClass = 'bg-secondary';
                                    }

                                    // Translate notification type
                                    $formattedType = trans('messages.types.' . strtolower($notification->type));
                                    if ($formattedType === 'messages.types.' . strtolower($notification->type)) {
                                        $formattedType = \Illuminate\Support\Str::title(str_replace('_', ' ', $notification->type));
                                    }
                                    
                                    // Translate status
                                    $status = trans('messages.notificationstatus.' . $notification->status);
                                    if ($status === 'messages.notificationstatus.' . $notification->status) {
                                        $status = $notification->status;
                                    }
                                @endphp

                                <div>
                                    <span class="badge {{ $badgeClass }} me-2 text-uppercase">
                                        {{ $formattedType }}
                                    </span>
                                    {{ $status }}
                                </div>
                                @if(!$notification->is_read)
                                <form method="POST" action="{{ route('admin.notifications.read', $notification->id) }}">
                                    @csrf
                                    <button class="btn btn-sm btn-outline-success" title="@lang('messages.ui.mark_as_read')">
                                        <i class="fas fa-check"></i>
                                    </button>
                                </form>
                                @else
                                    <form method="POST" action="{{ route('admin.notifications.unread', $notification->id) }}">
                                        @csrf
                                        <button class="btn btn-sm btn-outline-warning" title="@lang('messages.ui.mark_as_unread')">
                                            <i class="fas fa-flag"></i>
                                        </button>
                                    </form>
                                @endif
                            </div>

                            <p class="description">
                                {{ ucwords($notification->customer_name) }} - {{ $notification->customer_email }} - {{ $notification->customer_phone }}
                            </p>
                            
                            @if(is_array($notification->data))
                                <ul class="bk-details">
                                    @if(in_array($notification->type, ['new_booking_request','voucher_expired', 'payment_link_expired', 'new_SPO_registration', 'user_slot_change_request', 'SPO_product_enable', 'new_Query', 'SPO_product_administration', 'spo_product_request']))
                                        @foreach($notification->data as $item)
                                            @php
                                                // Translate label
                                                $label = trans('messages.labels.' . $item['label']);
                                                if ($label === 'messages.labels.' . $item['label']) {
                                                    $label = ucwords($item['label']);
                                                }
                                            @endphp
                                            <li><strong>{{ $label }}:</strong> {{ ucwords($item['value']) }}</li>
                                        @endforeach
                                    @else
                                        @foreach($notification->data as $key => $value)
                                            @php
                                                // Translate key
                                                $label = trans('messages.labels.' . $key);
                                                if ($label === 'messages.labels.' . $key) {
                                                    $label = ucwords(str_replace('_', ' ', $key));
                                                }
                                            @endphp
                                            <li><strong>{{ $label }}:</strong> {{ ucwords($value) }}</li>
                                        @endforeach
                                    @endif
                                </ul>
                            @else
                                <div class="small text-muted mt-2">{{ $notification->data }}</div>
                            @endif
                        </div>
                        <small class="time">{{ $notification->created_at->diffForHumans() }}</small>
                    </li>
                @endforeach
            </ul>

            <div class="mt-4 cs-pagination">
                {{ $notifications->links() }}
            </div>
        @endif
    </div>
</div>

<script>
    $(document).ready(function(){
        $('#searchNotifications').on('keyup', function(){
            let searchText = $(this).val().toLowerCase().trim();
            let hasResults = false;
            
            if (searchText === '') {
                $('#notificationList .notification-item').show();
                $('#notificationList .notification-item').addClass('d-flex');
                $('#noResults').addClass('d-none');
                return;
            }
            
            $('#notificationList .notification-item').each(function(){
                let notificationText = $(this).text().toLowerCase();
                
                if (notificationText.includes(searchText)) {
                    $(this).addClass('d-flex');
                    $(this).show();
                    hasResults = true;
                } else {
                    $(this).removeClass('d-flex');
                    $(this).hide();
                }
            });

            if (hasResults) {
                $('#noResults').addClass('d-none');
            } else {
                $('#noResults').removeClass('d-none');
            }
        });
    });
</script>
@endsection