@extends('layouts.admin')
@section('content')
<style>
    .ck-editor__editable{
        height: 200px;
    }
    .video-upload-preview {
        position: relative;
        border: 1px dashed #ddd;
        padding: 15px;
        border-radius: 5px;
        background: #f9f9f9;
    }

    .video-preview {
        position: relative;
        width: 100%;
        background: #000;
    }

    .video-preview video {
        width: 100%;
        max-height: 200px;
        object-fit: contain;
    }

    .video-preview .remove-video {
        position: absolute;
        top: 5px;
        right: 5px;
        background: rgba(0,0,0,0.5);
        color: white;
        border: none;
        border-radius: 50%;
        width: 25px;
        height: 25px;
        cursor: pointer;
    }

    .video-preview .remove-video:hover {
        background: rgba(255,0,0,0.7);
    }
    
    .existing-video {
        position: relative;
    }
</style>
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="{{route('admin.content.index')}}">Content management</a>
            <a class="active">Edit</a>
        </div>
    </div>

    <div class="add-user-form">
        <form class="row g-3" action="{{route('admin.admin_settings_update_page',$page_type)}}" method="POST" id="content_manage" enctype="multipart/form-data">
            @csrf

            <div class="col-md-12">
                <div class="comn-input-select">
                    <label for="page_title" class="form-label">Title</label>
                    <input type="text" class="form-control" name="page_title" id="page_title" value="{{ GetMetaData('page_title',$page_type) }}" placeholder="Enter Title">
                    @error('page_title') <small class="text-danger">{{ $message }}</small> @enderror
                </div>
            </div>

            <div class="col-md-12">
                <div class="comn-input-select">
                    <label for="title" class="form-label">Title</label>
                    <input type="text" class="form-control" name="title" id="title" value="{{ GetMetaData('title',$page_type) }}" placeholder="Enter Title">
                    @error('title') <small class="text-danger">{{ $message }}</small> @enderror
                </div>
            </div>

            <div class="col-md-12">
                <div class="comn-input-select">
                    <label for="description" class="form-label">Description</label>
                    <textarea class="form-control" id="description" name="description">{{ GetMetaData('description',$page_type) }}</textarea>
                    @error('description') <small class="text-danger">{{ $message }}</small> @enderror
                </div>
            </div>

            <div class="col-md-12">
                <div class="comn-input-select">
                    <label for="contact_title" class="form-label">Link</label>
                    <input type="text" class="form-control" name="right_link" id="contact_title" value="{{ GetMetaData('right_link',$page_type) }}" placeholder="Enter Title">
                </div>
            </div>

            <div class="row">
                <div class="col-md-4">
                    <label for="video1" class="form-label">Video 1 (Max 5MB)</label>
                    <div class="video-upload-preview">
                        <input name="video1" type="file" id="video1" class="form-control" accept="video/*" onchange="previewVideo(this, 'previewVideo1')">
                        <!-- Hidden field to track if existing video should be removed -->
                        <input type="hidden" name="remove_video1" id="remove_video1" value="0">
                        
                        @if(GetMetaData('video1',$page_type))
                        <div class="video-preview existing-video mt-2" id="existingVideo1">
                            <video width="100%" controls>
                                <source src="{{ asset('storage/'.GetMetaData('video1',$page_type)) }}" type="video/mp4">
                                Your browser doesn't support HTML5 video.
                            </video>
                            <button type="button" class="remove-video" onclick="removeExistingVideo('existingVideo1', 'remove_video1')">
                                <i class="fas fa-times"></i>
                            </button>
                            <small class="text-muted">Current video</small>
                        </div>
                        @endif
                        
                        <div class="video-preview mt-2 d-none" id="previewVideo1"></div>
                        <small class="text-danger d-none" id="video1Error">Video must be less than 5MB</small>
                    </div>
                </div>
            
                <div class="col-md-4">
                    <label for="video2" class="form-label">Video 2 (Max 5MB)</label>
                    <div class="video-upload-preview">
                        <input name="video2" type="file" id="video2" class="form-control" accept="video/*" onchange="previewVideo(this, 'previewVideo2')">
                        <!-- Hidden field to track if existing video should be removed -->
                        <input type="hidden" name="remove_video2" id="remove_video2" value="0">
                        
                        @if(GetMetaData('video2',$page_type))
                        <div class="video-preview existing-video mt-2" id="existingVideo2">
                            <video width="100%" controls>
                                <source src="{{ asset('storage/'.GetMetaData('video2',$page_type)) }}" type="video/mp4">
                                Your browser doesn't support HTML5 video.
                            </video>
                            <button type="button" class="remove-video" onclick="removeExistingVideo('existingVideo2', 'remove_video2')">
                                <i class="fas fa-times"></i>
                            </button>
                            <small class="text-muted">Current video</small>
                        </div>
                        @endif
                        
                        <div class="video-preview mt-2 d-none" id="previewVideo2"></div>
                        <small class="text-danger d-none" id="video2Error">Video must be less than 5MB</small>
                    </div>
                </div>
            
                <div class="col-md-4">
                    <label for="video3" class="form-label">Video 3 (Max 5MB)</label>
                    <div class="video-upload-preview">
                        <input name="video3" type="file" id="video3" class="form-control" accept="video/*" onchange="previewVideo(this, 'previewVideo3')">
                        <!-- Hidden field to track if existing video should be removed -->
                        <input type="hidden" name="remove_video3" id="remove_video3" value="0">
                        
                        @if(GetMetaData('video3',$page_type))
                        <div class="video-preview existing-video mt-2" id="existingVideo3">
                            <video width="100%" controls>
                                <source src="{{ asset('storage/'.GetMetaData('video3',$page_type)) }}" type="video/mp4">
                                Your browser doesn't support HTML5 video.
                            </video>
                            <button type="button" class="remove-video" onclick="removeExistingVideo('existingVideo3', 'remove_video3')">
                                <i class="fas fa-times"></i>
                            </button>
                            <small class="text-muted">Current video</small>
                        </div>
                        @endif
                        
                        <div class="video-preview mt-2 d-none" id="previewVideo3"></div>
                        <small class="text-danger d-none" id="video3Error">Video must be less than 5MB</small>
                    </div>
                </div>
            </div>
            
            <div class="col-md-12">
                <div class="comn-input-select">
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="is_header" id="is_header" {{ GetMetaData('is_header',$page_type) == 1 ? "checked" :"" }} value="1">
                        <label class="form-check-label" for="is_header">Header</label>
                      </div>
                      <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="is_footer" id="is_footer" value="1" {{ GetMetaData('is_footer',$page_type) == 1 ? "checked" :"" }}>
                        <label class="form-check-label" for="is_footer">Footer</label>
                      </div>
                </div>
            </div>
         
            <div class="col-12">
                <div class="upper-main-btn-last-comn d-flex">
                    <button type="submit" class="add-user">Save</button>
                    <button class="cancel-btn"><a href="{{route('admin.content.index')}}">Cancel</a></button>
                </div>
            </div>
        </form>
    </div>
</div>
<script src="https://cdn.ckeditor.com/ckeditor5/38.1.0/classic/ckeditor.js"></script>
<script>
    ClassicEditor
        .create(document.querySelector('#description'),{
            height: 300 
        })
        .catch(error => {
            console.error(error);
        });

    // Video preview and validation
    function previewVideo(input, previewId) {
        const previewElement = document.getElementById(previewId);
        const errorElement = document.getElementById(input.id + 'Error');
        const maxSize = 5 * 1024 * 1024; // 5MB in bytes
        
        // Reset previous state
        errorElement.classList.add('d-none');
        input.classList.remove('is-invalid');
        
        if (input.files && input.files[0]) {
            // Check file size
            if (input.files[0].size > maxSize) {
                input.value = ''; // Clear the file input
                input.classList.add('is-invalid');
                errorElement.classList.remove('d-none');
                previewElement.classList.add('d-none');
                return;
            }
            
            const file = input.files[0];
            const videoURL = URL.createObjectURL(file);
            
            // Hide existing video preview if it exists
            const existingVideoId = 'existing' + previewId.replace('preview', '');
            const existingVideo = document.getElementById(existingVideoId);
            if (existingVideo) {
                existingVideo.classList.add('d-none');
            }
            
            previewElement.innerHTML = `
                <video width="100%" controls>
                    <source src="${videoURL}" type="${file.type}">
                    Your browser doesn't support HTML5 video.
                </video>
                <button type="button" class="remove-video" onclick="removeNewVideo('${input.id}', '${previewId}', '${existingVideoId}')">
                    <i class="fas fa-times"></i>
                </button>
            `;
            previewElement.classList.remove('d-none');
        }
    }

    function removeNewVideo(inputId, previewId, existingVideoId) {
        const input = document.getElementById(inputId);
        const preview = document.getElementById(previewId);
        
        input.value = '';
        preview.innerHTML = '';
        preview.classList.add('d-none');
        
        // Show existing video again if it exists
        const existingVideo = document.getElementById(existingVideoId);
        if (existingVideo) {
            existingVideo.classList.remove('d-none');
        }
    }

    function removeExistingVideo(existingVideoId, removeVideoInputId) {
        const existingVideo = document.getElementById(existingVideoId);
        const removeVideoInput = document.getElementById(removeVideoInputId);
        
        existingVideo.classList.add('d-none');
        removeVideoInput.value = '1'; // Set to 1 to indicate this video should be removed
    }

    // Form submission validation
    document.getElementById('content_manage').addEventListener('submit', function(e) {
        const videoInputs = ['video1', 'video2', 'video3'];
        let isValid = true;
        const maxSize = 5 * 1024 * 1024; // 5MB in bytes
        
        videoInputs.forEach(id => {
            const input = document.getElementById(id);
            const errorElement = document.getElementById(id + 'Error');
            
            if (input.files.length > 0 && input.files[0].size > maxSize) {
                input.classList.add('is-invalid');
                errorElement.classList.remove('d-none');
                isValid = false;
            }
        });
        
        if (!isValid) {
            e.preventDefault();
            alert('Please fix the validation errors before submitting.');
        }
    });
</script>
@endsection