@extends('layouts.admin')
@section('content')
<style>


form#vendorFilterForm span#select2-vendorSelect-container {
    padding: 10px;
}



form#vendorFilterForm span.select2-selection {
    height: 50px;
    min-width: 230px;
    display: flex;
    align-items: center;
    font-size: 14px;
}

form#vendorFilterForm span.select2-selection__arrow {
    top: 14px;
}

form#vendorFilterForm .select2-results__option {
    padding: 10px 12px !important;
    font-size: 16px !important;
}


.select2-results__options li {
    padding: 8px;
    font-size: 14px;
}
</style>
<div class="col-9 main-dash-left">
    <div class="analytics">
        <div class="name-head">
            <h2>payment analytics</h2>
            <select class="form-select select-main-head" aria-label="Time period filter">
                <option value="year" {{ request('time_period') == 'year' ? 'selected' : '' }}>Year</option>
                <option value="month" {{ request('time_period') == 'month' ? 'selected' : '' }}>Month</option>
                <option value="week" {{ request('time_period') == 'week' ? 'selected' : '' }}>Week</option>
                <option value="day" {{ request('time_period') == 'day' ? 'selected' : '' }}>Today</option>
            </select>
        </div>
        <div class="cards-dashboard">
            <div class="row row-gap-3">
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-green">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="{{asset('admin/images/total.png')}}" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>PayPal Share</p>
                                    <h4>{{ $paypalPercentage }}%</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="{{asset('admin/images/green-line.png')}}" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-purple">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="{{asset('admin/images/return.png')}}" alt="">
                            </figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Credit Card Share</p>
                                    <h4>{{ $creditCardPercentage }}%</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="{{asset('admin/images/white-line.png')}}" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-yellow">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="{{asset('admin/images/top.png')}}" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Total Refunds</p>
                                    <h4>{{ number_format($totalRefunds, 2, ',', '.') }} €</h4>
                                    </div>
                                <figure class="img-graph">
                                    <img src="{{asset('admin/images/orange-line.png')}}" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-parrot">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="{{asset('admin/images/lost.png')}}" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Value of Reconciliation</p>
                                    <h4>{{ number_format($totalReconciliations, 2, ',', '.') }} €</h4>
                                    </div>
                                <figure class="img-graph">
                                    <img src="{{asset('admin/images/parot-line.png')}}" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- download-btns ------------------ -->
        <div class="sownload-cv-pdf">
            <a href="{{ route('admin.payments.export.pdf', request()->query()) }}" class="download-pdf">Download PDF</a>
            <a href="{{ route('admin.payments.export.csv', request()->query()) }}" class="download-pdf">Download CSV</a>
        </div>
        <div class="main-notification-messege">
            <div class="notifi-list d-flex">
                <h6>Payment Management</h6>
                <div class="dropdowns-inner-list d-flex">
                    <div class="dropdowns-inner-list">
                        <div class="icon-search-main white_bg">
                            <i class="fa-solid fa-magnifying-glass"></i>
                            <input aria-describedby="passwordHelpBlock" placeholder="Search For User"
                                type="text" id="payment_user" class="form-control" value="">
                        </div>
                    </div>
                    <div class="filter-main-div">
                        <p class="lable-filt">Filter:</p>
                        <div class="dropdown">
                            <button class="filter-btn dropdown-toggle" type="button" id="paymentFilterDropdown" 
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa-solid fa-filter"></i> Filter
                            </button>
                            <ul class="dropdown-menu" aria-labelledby="paymentFilterDropdown">
                                <li><a class="dropdown-item filter-payment active" href="#" data-status="all">All Payments</a></li>
                                <li><a class="dropdown-item filter-payment" href="#" data-status="paid">Completed</a></li>
                                <li><a class="dropdown-item filter-payment" href="#" data-status="unpaid">Cancelled</a></li>
                                <li><a class="dropdown-item filter-payment" href="#" data-status="refund">Refund</a></li>
                                <li><a class="dropdown-item filter-payment" href="#" data-status="reconciliation">Reconciliation</a></li>
                            </ul>
                        </div>
                    </div>

                    @php
                        $selectedVendorId = request('vendor_id');
                        $selectedVendorLabel = 'Esperantostr. 10, 70197 Stuttgart';
                        if ($selectedVendorId && $vendors->where('id', $selectedVendorId)->first()) {
                            $v = $vendors->where('id', $selectedVendorId)->first();
                            $selectedVendorLabel = "{$v->street} {$v->zip_code} {$v->city} (SPOID{$v->id})";
                        }
                    @endphp
                
                <div class="filter-main-div">
                    <p class="lable-filt">Vendor:</p>
                    <form id="vendorFilterForm">
                        <select id="vendorSelect" class="form-control" name="vendor_id" style="width: 300px;" data-placeholder="Select Vendor">
                            <option value="">Esperantostr. 10, 70197 Stuttgart</option>
                            @foreach($vendors as $vendor)
                                <option value="{{ $vendor->id }}"
                                    {{ request('vendor_id') == $vendor->id ? 'selected' : '' }}>
                                    {{ $vendor->street }} {{ $vendor->zip_code }} {{ $vendor->city }} (SPOID{{ $vendor->id }})
                                </option>
                            @endforeach
                        </select>
                    </form>
                </div>
                </div>
            </div>
            <div class="notification-table pt-0">
                <table id="bookingTable" class="table">
                    <thead>
                        <tr class="head-class-td">
                            <th>Booking ID</th>
                            <th>Payment ID</th>
                            <th>Customer Name</th>
                            <th>date</th>
                            <th>Payment method</th>
                            <th>amount</th>
                            <th>Refund Amount</th>
                            <th>Delay Fees</th>
                            <th>status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="searchPaymentUser">
                        @if(count($bookings) > 0)
                        @foreach ($bookings as $booking)
                        <tr data-status="{{ $booking->payment_status }}">
                            <td>#{{$booking->id}}</td>
                            <td>#{{$booking->stripe_payment_intent}}</td>
                            <td>{{$booking->userDetails->first_name." ".$booking->userDetails->last_name}}</td>
                            <td>{{ \Carbon\Carbon::parse($booking->created_at)->format('d.m.Y') }}</td>
                            <td>{{$booking->payment_method}}</td>
                            <td>{{number_format($booking->total , 2 , ',' , '.')}} €</td>
                            <td>{{number_format($booking->refund_amount,2,',','.')}} €</td>
                            <td>{{number_format($booking->delay_fees,2,',','.')}} €</td>
                            <td>
                                <select class="form-select select-active-block payment_status_select"
                                    aria-label="Default select example"
                                    data-current-status="{{ $booking->payment_status }}"     {{ $booking->payment_status == 'refund' ? 'disabled' : '' }}>
                                    <option value="paid" class="confirmed-op" {{ $booking->payment_status == "paid" ? "selected" : "" }}>Completed</option>
                                    <option value="unpaid" class="cancel-op" {{ $booking->payment_status == "unpaid" ? "selected" : "" }}>Cancelled</option>
                                    <option value="refund" class="refund-op" {{ $booking->payment_status == "refund" ? "selected" : "" }} class="text-danger">Refund</option>
                                    <option value="reconciliation" class="completed-op" {{ $booking->payment_status == "reconciliation" ? "selected" : "" }} class="text-warning">Reconciliation</option>
                                </select>   
                            </td>
                            <td>
                                <div class="upper-delete-btns d-flex">
                                    <a class="view-btn-eye" href="{{route('admin.view.payment.history',[$booking->id])}}">
                                        <i class="fa-solid fa-eye"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="modal fade modal-delete-logout" id="changestatus" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="status-text">Are you sure you want to change status?</h4>
                    <div id="refund-amount-group" class="mb-3" style="display:none;">
                        <p style = "margin-top : -28px ; margin-bottom : 1rem; font-size: 12px"><strong> Attention : </strong> You can enter the refund just once. Corrections not allowed </p>
                        <label for="refund-amount" class="form-label">Enter refund amount</label>
                        <input type="number" class="form-control" id="refund-amount" name="refund_amount" min="0" step="0.01" required>
                    </div>
                    <div class="upper-btns-modal-pair">
                        <button type="button" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">No</button>
                        <form id="status-change-form" method="POST" action="">
                            @csrf
                            <input type="hidden" name="payment_status" id="new-status">
                            <input type="hidden" name="refund_amount" id="new_refund_amount">
                            <button type="submit" class="comn-modal-btns-blue btn btn-primary">Yes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {
        $('#bookingTable').DataTable({
        paging: true,
        searching: true, 
        info: true,
        lengthChange: true,
        pageLength: 10,
        ordering: false, 
        language: {
            lengthMenu: 'Show _MENU_ entries',
            paginate: {
                previous: '&laquo;',
                next: '&raquo;'
            }
        },
        dom: '<"top"lf>rt<"bottom"ip><"clear">'
    });

    // $('#payment_user').on('keyup', function () {
    //     $('#bookingTable').DataTable().search(this.value).draw();
    // });

    
        $('#vendorSelect').select2({
            placeholder: "Select Vendor",
            allowClear: true
        });
    
        $('#vendorSelect').on('change', function () {
            const url = new URL(window.location.href);
            const vendorId = $(this).val();
    
            if (vendorId) {
                url.searchParams.set('vendor_id', vendorId);
            } else {
                url.searchParams.delete('vendor_id');
            }
    
            window.location.href = url.toString();
        });
    });
    </script>
<script>
    
    var baseUrl = "{{ rtrim(config('app.url'), '/') }}";
$(document).ready(function() {
    // Initialize variables
    let activeStatus = 'all';
    let activeSearch = '';
    let activeTimePeriod = $('.select-main-head').val();

    // Function to update download links with current filters
    function updateDownloadLinks() {
        const timePeriod = $('.select-main-head').val();
        const status = $('.filter-payment.active').data('status');
        const search = $('#payment_user').val();
        const vendor = {{ request('vendor_id') ? (int) request('vendor_id') : 'null' }};

        
        
        // Update both download links
        $('.download-pdf').each(function(index) {
            let baseUrl = $(this).attr('href').split('?')[0];
            $(this).attr('href', 
                `${baseUrl}?time_period=${timePeriod}&status=${status}&search=${encodeURIComponent(search)}&vendor_id=${vendor}`
            );
        });
    }

    // Function to filter the payment table
    function filterPaymentTable() {
        const rows = $('#searchPaymentUser tr');
        let hasVisibleRows = false;
        
        rows.each(function() {
            if ($(this).text().trim() === 'No payments found.') {
                return true; // continue
            }
            
            const statusMatch = activeStatus === 'all' || 
                              $(this).data('status') === activeStatus;
            const searchMatch = activeSearch === '' || 
                              $(this).text().toLowerCase().includes(activeSearch);
            
            if (statusMatch && searchMatch) {
                $(this).show();
                hasVisibleRows = true;
            } else {
                $(this).hide();
            }
        });
        
        // Show "no results" message if needed
        const noResultsRow = $('#searchPaymentUser tr.text-center');
        if (noResultsRow.length) {
            noResultsRow.toggle(!hasVisibleRows);
        }
    }

    // Initialize on page load
    updateDownloadLinks();
    filterPaymentTable();

    // Payment status filter functionality
    $('.filter-payment').on('click', function(e) {
        e.preventDefault();
        
        // Update active status
        $('.filter-payment').removeClass('active');
        $(this).addClass('active');
        activeStatus = $(this).data('status');
        
        // Update dropdown button text
        $('#paymentFilterDropdown').html(`<i class="fa-solid fa-filter"></i> ${$(this).text().trim()}`);
        
        // Update and filter
        updateDownloadLinks();
        filterPaymentTable();
    });
    
    // Search functionality
    $('#payment_user').on('keyup', function() {
        activeSearch = $(this).val().trim().toLowerCase();
        $('#bookingTable').DataTable().search(this.value).draw();
        updateDownloadLinks();
        // filterPaymentTable();
    });
    
    // Time period filter change
    $('.select-main-head').on('change', function() {
        activeTimePeriod = $(this).val();
        updateDownloadLinks();
        
        const url = new URL(window.location.href);
        url.searchParams.set('time_period', activeTimePeriod);
        window.history.pushState({}, '', url);
        location.reload();

    });

    // Payment status change modal
    $('.payment_status_select').on('change', function() {
        const $select = $(this);
        const selectedValue = $select.val();
        const bookingId = $select.closest('tr').find('td:first').text().replace('#', '');
        const currentStatus = $select.data('current-status') || "";

        // Don't proceed if status didn't actually change
        if (selectedValue === currentStatus) {
            return;
        }

        const formAction = `${baseUrl}/admin/bookings/${bookingId}/update-payment-status`;
        $('#status-change-form').attr('action', formAction);
        
        $('#new-status').val(selectedValue);
        
        let message = '';
        switch (selectedValue) {
            case 'paid':
                message = 'Are you sure you want to mark this payment as Completed?';
                $('#refund-amount-group').hide();
                break;
            case 'unpaid':
                message = 'Are you sure you want to mark this payment as Canceled?';
                $('#refund-amount-group').hide();
                break;
            case 'refund':
                message = 'Are you sure you want to mark this payment as Refunded?';
                $('#refund-amount-group').show();
                break;
            case 'reconciliation':
                message = 'Are you sure you want to mark this payment as Reconciliation?';
                $('#refund-amount-group').hide();
                break;
            default:
                $('#refund-amount-group').hide();
        }
        
        $('#status-text').text(message);
        $('#changestatus').modal('show');
        $('#changestatus').data('select', $select);
        $('#changestatus').data('current-status', currentStatus);
    });

    // Handle form submission
    $('#status-change-form').on('submit', function(e) {
        e.preventDefault();
        
        const form = $(this);
        const url = form.attr('action');
        const $select = $('#changestatus').data('select');
        const currentStatus = $('#changestatus').data('current-status');
        const newStatus = $('#new-status').val();
        

        if (newStatus === 'refund') {
            const refundAmount = $('#refund-amount').val();
            if (!refundAmount || parseFloat(refundAmount) <= 0) {
                alert('Please enter a valid refund amount.');
                return;
            }
            $('#new_refund_amount').val(refundAmount);
        }
        
        $.ajax({
            url: url,
            type: 'POST',
            dataType: 'json',
            data: form.serialize(),
            success: function(data) {
                if(data.success) {
                    $select.data('current-status', $('#new-status').val());
                    $('#changestatus').modal('hide');
                    Swal.fire({
                        icon: 'success',
                        title: 'Payment Status',
                        text: 'Payment status updated successfully!',
                    }).then((result) => {
                        if (result.isConfirmed) {
                            window.location.reload();
                        }
                    });
                }
            },
            error: function(xhr) {
                let msg = 'Error updating payment status. Please try again.';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    msg = xhr.responseJSON.message;
                }

                Swal.fire({
                    icon: 'error',
                    title: 'Booking Status',
                    text: msg,
                });

                // revert status select
                $select.val(currentStatus);
                $('#changestatus').modal('hide');
            }
        });
    });

    // Handle modal close/cancel
    $('#changestatus').on('hidden.bs.modal', function() {
        const $select = $(this).data('select');
        const currentStatus = $(this).data('current-status');
        if ($select && currentStatus) {
            $select.val(currentStatus);
        }
    });
});
</script>
@endsection