@extends('layouts.admin')
@section('content')
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="{{route('admin.payment.index')}}">payment management</a>
            <a class="active" href="">payment Details</a>
        </div>
    </div>

    <div class="add-user-form">
        <h2 class="head-mian-all-payment">Payment Details</h2>
        <div class="main-show-detail-viwe">
            <div class="inner-pack-view">
                <h3>User Details:</h3>
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>Customer ID</h5>
                        <p>#{{$booking->userDetails->user_id}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Customer Name</h5>
                        <p>{{$booking->userDetails->title." ".$booking->userDetails->first_name." ".$booking->userDetails->last_name}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Street, house number:</h5>
                        <p>{{$booking->userDetails->address}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Zip Code</h5>
                        <p>{{$booking->userDetails->zip}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>City</h5>
                        <p>{{$booking->userDetails->city}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>region/state:</h5>
                        <p>{{$booking->userDetails->country}}</p>
                    </div>
                </div>

                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>email Address</h5>
                        <p>{{$booking->userDetails->email}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Phone Number</h5>
                        <p>{{$booking->userDetails->phone }}</p>
                    </div>
                </div>
            </div>

            @foreach($booking->items as $item)
            <div class="car-details-wrap">
            <div class="inner-pack-view">
                <h3>Car Details:</h3>
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>Brand</h5>
                        <p>{{ explode(' ', $item->car_name)[0] }}</p> <!-- Gets first word as brand -->
                    </div>
                    <div class="patient-anme-view">
                        <h5>Year</h5>
                        <p>{{ $item->car_year }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Model</h5>
                        <p>{{ $item->model }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Trailer Hitch</h5>
                        <p>{{ $item->trailer_hitch ? 'Yes' : 'No' }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Roof Type</h5>
                        <p>{{ $item->roof_type }}</p>
                    </div>
                </div>
            </div>

            <div class="inner-pack-view">
                <h3>Product Details:</h3>
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>Product ID</h5>
                        <p>#{{$item->product_id}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Product Name</h5>
                        <p>{{$item->product_name}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Size/ Variation</h5>
                        <p>{{$item->size}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Color</h5>
                        <p>{{$item->color}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Insurance</h5>
                        <p>{{$item->is_insured ? 'Yes' : 'No'}}</p>
                    </div>
                </div>
        
            </div>
            </div>
            @endforeach

            <div class="inner-pack-view border-0 mb-0">
                <h3>Payment Details:</h3>
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>Subtotal</h5>
                        <p>{{number_format($booking->subtotal , 2 , ',' , '.')}} €</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Tax</h5>
                        <p>{{number_format($booking->tax , 2 , ',' , '.')}} €</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Discount</h5>
                        <p>{{number_format($booking->discount , 2 , ',' , '.')}} €</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Total Amount</h5>
                        <p>{{number_format($booking->total , 2 , ',' , '.')}} €</p>
                    </div>

                    <div class="patient-anme-view">
                        <h5>Total Refund Amount</h5>
                        <p>{{number_format($booking->refund_amount,2,',','.')}} €</p>
                    </div>
                </div>
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>Payment Method</h5>
                        <p>{{ucfirst($booking->payment_method)}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Payment Status</h5>
                        <p>{{ucfirst($booking->payment_status)}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Booking Date</h5>
                        <p>{{$booking->created_at->format('d.m.Y')}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Booking Status</h5>
                        <p>{{ucfirst($booking->status)}}</p>
                    </div>
                </div>
                @if($booking->payment_method == 'stripe')
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>Stripe Session ID</h5>
                        <p>{{$booking->stripe_session_id}}</p>
                    </div>
                    @if($booking->stripe_payment_intent)
                    <div class="patient-anme-view">
                        <h5>Stripe Payment Intent</h5>
                        <p>{{$booking->stripe_payment_intent}}</p>
                    </div>
                    @endif
                </div>
                @endif
            </div>
        </div>
        <div class="upper-main-btn-last-comn d-flex">
            <a href="{{ route('admin.payment.index') }}" class="add-user">
                Back to List
            </a>
        </div>
    </div>
</div>
@endsection