@extends('layouts.admin')
@section('content')
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="{{route('admin.price.index')}}">pricing management</a>
            <a class="active" href="">Edit Pricing Details</a>
        </div>
    </div>

    <div class="add-user-form">
        <h3>Edit pricing details</h3>
        <form class="row g-3" action="{{route('admin.update.price',[$productPrice->id])}}" method="POST" id="priceForm">
            @csrf
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="category_name" class="form-label">category name</label>
                    <input type="text" class="form-control" id="category_name" name="category_name" readonly placeholder="Category Name" value="{{$productPrice->category_name}}">
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="product_name" class="form-label">Product Name</label>
                    <input type="text" class="form-control" id="product_name" name="product_name" readonly placeholder="Product Name" value="{{$productPrice->product_name}}">
                </div>
            </div>
          
            @foreach ($productPrice->weekDays() as $wkIndex => $weeklyPrice)
            <h3 class="edit_pircing_inner_heading">week {{$wkIndex+1}} pricing</h3>
            @foreach ($weeklyPrice as $kp => $wprice)
            <div class="col-md-4">
                <div class="comn-input-select">
                    <label for="price_{{$wkIndex."_".$kp}}" class="form-label">day {{$kp+1}}</label>
                    <input type="text" class="form-control price-input" id="price_{{$wkIndex."_".$kp}}" name="week[]" placeholder="Price" value="{{$wprice}}">
                    <span class="error-message" style="color: red; display: none;">Invalid format. Please enter a valid price like 33,32 €.</span>
                </div>
            </div>
            @endforeach
            @endforeach

            <div class="upper-main-btn-last-comn d-flex">
                <button type="submit" class="add-user">Save Changes</button>
                <a href="{{route("admin.price.index")}}" class="delete-cancel-btn">Cancel</a>
            </div>
        </form>
    </div>
</div>

@push('script')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('priceForm');
        const priceInputs = document.querySelectorAll('.price-input');
        
        priceInputs.forEach(input => {
            input.addEventListener('blur', function() {
                validatePrice(this);
            });
        });
        
        form.addEventListener('submit', function(e) {
            let isValid = true;
            let firstInvalidInput = null;
            
            priceInputs.forEach(input => {
                if (!validatePrice(input)) {
                    isValid = false;
                    if (!firstInvalidInput) {
                        firstInvalidInput = input;
                    }
                }
            });
            
            if (!isValid) {
                e.preventDefault();
                firstInvalidInput.scrollIntoView({
                    behavior: 'smooth',
                    block: 'center'
                });
            }
        });
        
        function validatePrice(input) {
            const value = input.value.trim();
            const regex = /^\d{1,2},\d{2} €$/;
            
            if (!regex.test(value)) {
                input.classList.add('is-invalid');
                input.nextElementSibling.style.display = 'inline';
                return false;
            } else {
                input.classList.remove('is-invalid');
                input.nextElementSibling.style.display = 'none';
                return true;
            }
        }
    });
</script>
<style>
    .is-invalid {
        border-color: #dc3545 !important;
    }
</style>
@endpush
@endsection