@extends('layouts.admin')
@section('content')
    <div class="col-9 main-dash-left">
        <div class="comm_head_top">
            <div class="name-head">
                <h2>Pricing Management</h2>
                <div class="d-flex comm_head_top_right">
                    <div class="sownload-cv-pdf">
                        <button  class="download-pdf" onclick="downloadPricePdf()">Download PDF</button>
                        <button class="download-pdf" onclick="downloadCSV()">Download CSV</button>
                    </div>
                </div>
            </div>
        </div>

        <div class="main-notification-messege">
            <div class="notifi-list d-flex">
                <h6></h6>
                <div class="dropdowns-inner-list d-flex">
                    <div class="dropdowns-inner-list">
                        <div class="icon-search-main white_bg">
                            <i class="fa-solid fa-magnifying-glass"></i>
                            <input aria-describedby="passwordHelpBlock" placeholder="Search For Products" type="text" 
                                   id="searchInput" class="form-control" value="">
                        </div>
                    </div>
                    <div class="filter-main-div">
                        <p class="lable-filt">Filter:</p>
                        <div class="dropdown">
                            <button class="filter-btn dropdown-toggle" type="button" id="categoryFilterDropdown" 
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa-solid fa-filter"></i> Filter
                            </button>
                            <ul class="dropdown-menu" aria-labelledby="categoryFilterDropdown">
                                <li><a class="dropdown-item filter-category active" href="#" data-category="all">All Categories</a></li>
                                @foreach($productPrices as $productPrice)
                                    <li><a class="dropdown-item filter-category" href="#" 
                                           data-category="{{ \Illuminate\Support\Str::slug($productPrice->category_name) }}">{{ $productPrice->category_name }}</a></li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    <button class="add-notification-btn" onclick="downloadCSV()">Price Download CSV</button>
                    
                        <button type="button" class="add-notification-btn" data-bs-toggle="modal" data-bs-target="#uploadCsvModal">
                            Upload Price CSV
                        </button>
                   
                </div>
            </div>
            
            <div class="notification-table comm_large_table pt-0">
                <table class="table">
                    <thead>
                        <tr class="head-class-td">
                            <th>Category name</th>
                            <th>Product name</th>
                            <th>W1</th>
                            <th>W2</th>
                            <th>W3</th>
                            <th>W4</th>
                            <th>W5</th>
                            <th>W6</th>
                            <th>W7</th>
                            <th>W8</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="pricingTableBody">
                        @if (count($productPrices))
                            @foreach ($productPrices as $productPrice)
                                <tr data-category="{{ \Illuminate\Support\Str::slug($productPrice->category_name) }}" 
                                    data-product="{{ strtolower($productPrice->product_name) }}">
                                    <td>{{ $productPrice->category_name }}</td>
                                    <td>{{ $productPrice->product_name }}</td>

                                    @foreach ($productPrice->getSevenDayTotals() as $wk => $weeklyPrice)
                                        <td>
                                            <div class="d-flex cursor-pointer gap-2 weekDaysModal"
                                                data-week_index="{{ $wk }}"
                                                data-week_total="{{ reformatPrice($weeklyPrice) }}" data-bs-toggle="modal"
                                                data-week_days="{{ json_encode($productPrice->weekDays()[$wk]) }}"
                                                data-bs-target="#pricing_table_modal">
                                                {{ reformatPrice($weeklyPrice) }} <i class="fa-solid fa-angle-down"></i>
                                            </div>
                                        </td>
                                    @endforeach

                                    <td>
                                        <div class="upper-delete-btns d-flex">
                                            <a class="view-btn-eye" href="{{ route('admin.price.show', $productPrice->id) }}">
                                                <i class="fa-solid fa-eye"></i>
                                            </a>
                                            <a class="edit-btn-eye" href="{{ route('admin.price.edit', $productPrice->id) }}">
                                                <i class="fa-solid fa-pen-to-square"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr class="text-center"><td colspan="12">No record found!</td></tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Upload Price CSV Modal -->
    <div class="modal fade" id="uploadCsvModal" tabindex="-1" aria-labelledby="uploadCsvModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="uploadCsvModalLabel">Upload Price CSV File</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
    
                <form action="{{ route('admin.upload.price.csv') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
    
                        <!-- ⚠️ Attention Panel -->
                        <div style="
                            display:flex;
                            gap:.6rem;
                            align-items:flex-start;
                            border:1px solid #f0c36d;
                            background:#fff8e5;
                            color:#5c3b00;
                            padding:.9rem 1rem;
                            border-radius:.5rem;
                            font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;
                            margin-bottom:1rem;
                            font-size:14px">
                            <span aria-hidden="true" style="font-size:1.2rem;line-height:1.2rem;">⚠️</span>
                            <div>
                                <strong>Attention!</strong>
                                <span>
                                    Do not modify any information in <strong>line 1</strong>. 
                                    Changing the <strong>product category names</strong> will disrupt the 
                                    <strong>pricing view in the SA backend</strong>.
                                </span>
                            </div>
                        </div>
    
                        <!-- File Upload Input -->
                        <div class="mb-3">
                            <label for="price_csv_upload_input" class="form-label">Select CSV File</label>
                            <input class="form-control" type="file" id="price_csv_upload_input" name="file" accept=".csv" required>
                            <div class="form-text">Please upload a valid Price CSV file.</div>
                        </div>
    
                    </div>
    
                    <div class="modal-footer">
                        <button type="button" class="cancel-btn" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="add-user">Upload</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    

    <!-- Modal -->
    <div class="modal fade large_modal comm_modal " id="pricing_table_modal" data-bs-keyboard="false" tabindex="-1"
        aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered ">
            <div class="modal-content">
                <i class="fa-solid fa-circle-xmark  modal_comm_close" data-bs-dismiss="modal"></i>
                <div class="p-0 modal-body">
                    <div class="comm_modal_head">
                        <h4 class="comm_modal_heading text-center" id="price_breakdown_heading">Price breakdown of week 1</h4>
                        <p class="comm_modal_sub_heading text-center" id="week_price_total">Total price 83,30 € </p>
                    </div>
                    <div class="patient-age-name d-flex mb-0"></div>
                </div>
            </div>
        </div>
    </div>

    @push('script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.28/jspdf.plugin.autotable.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/papaparse@5.4.1/papaparse.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            let activeCategory = 'all';
            let activeSearch = '';
            
            // Category filter functionality
            const categoryFilterItems = document.querySelectorAll('.filter-category');
            const dropdownButton = document.querySelector('#categoryFilterDropdown');
            
            categoryFilterItems.forEach(item => {
                item.addEventListener('click', function(e) {
                    e.preventDefault();
                    
                    // Update active category
                    categoryFilterItems.forEach(el => el.classList.remove('active'));
                    this.classList.add('active');
                    activeCategory = this.dataset.category;
                    
                    // Update dropdown button text
                    dropdownButton.innerHTML = `<i class="fa-solid fa-filter"></i> ${this.textContent.trim()}`;
                    
                    // Filter the table
                    filterPricingTable();
                });
            });
            
            // Search functionality
            const searchInput = document.getElementById('searchInput');
            searchInput.addEventListener('input', function() {
                activeSearch = this.value.trim().toLowerCase();
                filterPricingTable();
            });
            
            // Filter function
            function filterPricingTable() {
                const rows = document.querySelectorAll('#pricingTableBody tr');
                let hasVisibleRows = false;
                
                rows.forEach(row => {
                    const categoryMatch = activeCategory === 'all' || 
                                        row.dataset.category === activeCategory;
                    const searchMatch = activeSearch === '' || 
                                      row.dataset.product.includes(activeSearch) || 
                                      row.textContent.toLowerCase().includes(activeSearch);
                    
                    if (categoryMatch && searchMatch) {
                        row.style.display = '';
                        hasVisibleRows = true;
                    } else {
                        row.style.display = 'none';
                    }
                });
                
                // Show "no results" message if needed
                const noResultsRow = document.querySelector('#pricingTableBody tr.text-center');
                if (noResultsRow) {
                    noResultsRow.style.display = hasVisibleRows ? 'none' : '';
                }
            }
            
            // Initialize the table filtering
            filterPricingTable();
            
            // CSV upload functionality
            $('form[action="{{ route('admin.upload.price.csv') }}"]').on('submit', function(e) {
                e.preventDefault();
                let fileInput = $('#price_csv_upload_input')[0];
                if (!fileInput.files.length) {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Please select a CSV file first!'
                    });
                    return;
                }


                let formData = new FormData(this);
                let uploadBtn = $(this).find('button[type="submit"]');
                uploadBtn.prop('disabled', true).text('Uploading...');


                $.ajax({
                    url: $(this).attr('action'),
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        // Hide loader and enable the button
                        $('#loader').hide();
                        $('#price_csv_upload').prop('disabled', false);

                        // SweetAlert Success Message
                        Swal.fire({
                            icon: 'success',
                            title: 'File Uploaded Successfully!',
                            text: 'Your file has been uploaded.',
                        }).then((result) => {
                            if (result.isConfirmed) {
                                $('#uploadCsvModal').modal('hide');
                                location.reload();
                            }
                        });
                        $('#price_csv_upload').val('');
                    },
                    error: function(xhr, status, error) {
                        // Hide loader and enable the button
                        $('#loader').hide();
                        $('#price_csv_upload').prop('disabled', false);

                        // SweetAlert Error Message
                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: 'Something went wrong, please try again!',
                        });
                    }
                });
            });

            $('.weekDaysModal').click(function() {
                let week = $(this).data('week_days');
                let weekTotal = $(this).data('week_total');
                let weekNumber = $(this).data('week_index');
                $('#price_breakdown_heading').text('Price breakdown of week ' + (weekNumber + 1));
                $('#week_price_total').text('Total price ' + weekTotal);
                $('.patient-age-name').empty();

                // Loop through the array and generate HTML for each day
                week.forEach(function(price, index) {
                    let dayNumber = index + 1;
                    let dayHtml = `
                        <div class="patient-anme-view">
                            <h5>Day ${dayNumber}</h5>
                            <p>${price}</p>
                        </div>
                    `;
                    $('.patient-age-name').append(dayHtml);
                });
            });
        });

        function downloadCSV() {
            const link = document.createElement('a');
            link.href = "{{ asset('storage/csv_files/product_prices.csv') }}";
            link.download = "product_prices.csv";
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }

        async function downloadCSVasPDF() {
            const csvUrl = "{{ asset('storage/csv_files/product_prices.csv') }}";
            const response = await fetch(csvUrl);
            const csvText = await response.text();

            // Parse CSV using PapaParse
            const parsed = Papa.parse(csvText, {
                skipEmptyLines: true
            });

            const rows = parsed.data;

            const { jsPDF } = window.jspdf;
            const doc = new jsPDF();

            doc.autoTable({
                head: [rows[0]],
                body: rows.slice(1),
            });

            doc.save('product_prices.pdf');
        }

        function downloadPricePdf() {
            window.open("{{ route('admin.product-prices.pdf') }}", '_blank');
        }
    </script>
    @endpush
@endsection