@extends('layouts.admin')
@section('content')
        <div class="col-9 main-dash-left">
            <div class="upper-main-user-navigation">
                <div class="user-manage">
                    <a href="{{ route('admin.products.index') }}">product management</a>
                    <a class="active" href="">Add Product</a>
                </div>
            </div>

            <div class="add-user-form">
                <h3>Add Product</h3>
                <form class="row" method="POST" action="{{ route('admin.products.store') }}" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-md-4">
                            <div class="comn-input-select ">
                                <label for="product-name" class="form-label">Product Name<span class="text-danger">*</span></label>
                                <input type="text" class="form-control required" placeholder="Enter Product Name"
                                    id="product-name" name="name" >
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="comn-input-select ">
                                <label for="inputAddress" class="form-label">Product category<span class="text-danger">*</span></label>
                                <select id="category" class="form-select required" name="category_id">
                                    <option value="" selected>Select Product Category</option>
                                    @foreach($categories as $category)
                                        <option 
                                            value="{{ $category->id }}"
                                            data-size_ids='@json($category->size_ids ?? [])'
                                            data-variation_ids='@json($category->variation_ids ?? [])'
                                            data-color_ids='@json($category->color_ids ?? [])'
                                        >
                                            {{ $category->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        
                        <div class="col-md-4">
                            <div class="comn-input-select ">
                                <label for="inputAddress" class="form-label">Product brand<span class="text-danger">*</span></label>
                                <select id="brand" class="form-select required" name="brand_id" >
                                    <option value ="" selected>select product brand</option>
                                    @foreach($brands as $brand)
                                    <option value="{{ $brand->id }}">{{ $brand->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="comn-input-select ">
                                <label for="inputState1" class="form-label multiselect-form">description<span class="text-danger">*</span></label>
                                <textarea class="form-control required" placeholder="Enter Description" 
                                    style="height: 145px; resize:none;" name="description"></textarea>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="comn-input-select">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="railing_type" name="railing_type" value="1" 
                                        @if(isset($product) && $product->railing_type) checked @endif>
                                    <label class="form-check-label" for="railing_type">
                                        Railing Type Required <span class="text-danger">*</span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="inner-add-color d-none" id="inner-add-color">
                        <div id="variation-container">
                            <div class="variation-block">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="d-flex cst_slec_size_outer_row">
                                            <div class="main-flex-all">
                                                <div class="comn-input-select cst_slc_input ">
                                                    <label for="last-name" class="form-label">size/variation<span class="text-danger">*</span></label>
                                                    <select class="form-select size-select required" name="variations[0][size_id]" >
                                                        <option value="" selected>Select Size</option>
                                                        @foreach($sizes as $size)
                                                        <option value="{{ $size->id }}">{{ $size->name }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="comn-input-select">
                                                    <label>quantity<span class="text-danger">*</span>:</label>
                                                </div>
                                                <div class="comn-input-select">
                                                    <label>SKU<span class="text-danger">*</span>:</label>
                                                </div>
                                            </div>
                                            <div class="d-flex comm_slec_size_row">
                                                @foreach($colors as $color)
                                                <div class="comm_slec_size_col">
                                                    <div class="clr_box" style="background-color: white ; color: black">
                                                        <div class="cross remove-color"> <i class="fa-solid fa-xmark"></i> </div>
                                                        {{ $color->name }}
                                                        <input type="hidden" name="variations[0][colors][{{ $color->id }}][color_id]" value="{{ $color->id }}">
                                                    </div>
                                                    <div class="comn-input-select">
                                                        <input type="text" class="form-control required" placeholder="Enter Quantity" name="variations[0][colors][{{ $color->id }}][quantity]" >
                                                    </div>
                                                    <div class="comn-input-select">
                                                        <input type="text" class="form-control required" placeholder="Enter SKU" name="variations[0][colors][{{ $color->id }}][sku]" >
                                                    </div>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="comn-input-select ">
                                            <label for="last-name" class="form-label">Product Weight</label>
                                          
                                            <div class="price_icon_input">
                                                 <input type="text" class="form-control " placeholder="Enter Product Weight" name="variations[0][weight]">
                                                <p>Kg</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="comn-input-select  ">
                                            <label for="inputState" class="form-label">Status<span class="text-danger">*</span></label>
                                            <select id="inputState" class="form-select required" name="variations[0][status]">
                                                <option value=""selected>Select Status</option>
                                                <option value="in_stock">In Stock</option>
                                                <option value="out_of_stock">Out of Stock</option>
                                                <option value="pre_order">Pre-order</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="comn-input-select mb-2 ">
                                            <label for="inputCity" class="form-label mb-0">Product Dimensions</label>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="comn-input-select ">
                                                    <label class="form-label">length</label>
                                                    <div class="price_icon_input">
                                                        <input type="text" class="form-control " placeholder="Enter length" name="variations[0][length]">
                                                        <p>mm</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="comn-input-select ">
                                                    <label class="form-label">width</label>
                                                    <div class="price_icon_input">
                                                        <input type="text" class="form-control " placeholder="Enter Width" name="variations[0][width]">
                                                        <p>mm</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="comn-input-select ">
                                                    <label class="form-label">height</label>
                                                    <div class="price_icon_input">
                                                        <input type="text" class="form-control " placeholder="Enter height" name="variations[0][height]">
                                                        <p>mm</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="comn-input-select ">
                                            <label class="form-label">Volume</label>
                                            <div class="price_icon_input">
                                                <input type="number" class="form-control " placeholder="Enter Volume" name="variations[0][volume]">
                                                <p>L</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="comn-input-select ">
                                            <label class="form-label">Max. Load</label>
                                            <div class="price_icon_input">
                                                <input type="number" class="form-control " placeholder="Enter Max. Load" name="variations[0][max_load]">
                                                <p>Kg</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12 text-end" id="removeVariationBtn">
                                        <button type="button" class="btn add-user remove-variation">Remove Variation</button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <button type="button" id="add-variation" class="add-user">Add another size/variation</button>
                    </div>

                    



                    <div class="inner-add-color d-none" id="non-variant-block">
                        <div id="non-variation-container">
                            <div class="non-variation-block">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="d-flex cst_slec_size_outer_row">
                                            <div class="main-flex-all">
                                                <div class="comn-input-select cst_slc_input ">
                                                    <label for="last-name" class="form-label">size/variation<span class="text-danger">*</span></label>
                                                    <select class="form-select required" disabled><option selected="" >None</option></select>
                                                <div class="invalid-feedback">This field is required</div></div>
                                              
                                            </div>
                                           
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="comn-input-select ">
                                            <label for="last-name" class="form-label">Product Weight</label>
                                          
                                            <div class="price_icon_input">
                                                 <input type="text" class="form-control " placeholder="Enter Product Weight" name="weight">
                                                <p>Kg</p>
                                            </div>
                                        <div class="invalid-feedback">This field is required</div></div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="comn-input-select  ">
                                            <label for="inputState" class="form-label">Status<span class="text-danger">*</span></label>
                                            <select id="inputState" class="form-select required" name="status">
                                                <option value="" selected="">Select Status</option>
                                                <option value="in_stock">In Stock</option>
                                                <option value="out_of_stock">Out of Stock</option>
                                                <option value="pre_order">Pre-order</option>
                                            </select>
                                        <div class="invalid-feedback">This field is required</div></div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="comn-input-select mb-2 ">
                                            <label for="inputCity" class="form-label mb-0">Product Dimensions </label>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="comn-input-select ">
                                                    <label class="form-label">length</label>
                                                    <div class="price_icon_input">
                                                        <input type="text" class="form-control " placeholder="Enter length" name="length">
                                                        <p>cm</p>
                                                    </div>
                                                <div class="invalid-feedback">This field is required</div></div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="comn-input-select ">
                                                    <label class="form-label">width</label>
                                                    <div class="price_icon_input">
                                                        <input type="text" class="form-control " placeholder="Enter Width" name="width">
                                                        <p>cm</p>
                                                    </div>
                                                <div class="invalid-feedback">This field is required</div></div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="comn-input-select ">
                                                    <label class="form-label">height</label>
                                                    <div class="price_icon_input">
                                                        <input type="text" class="form-control " placeholder="Enter height" name="height">
                                                        <p>cm</p>
                                                    </div>
                                                <div class="invalid-feedback">This field is required</div></div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="comn-input-select ">
                                            <label class="form-label">Volume</label>
                                            <div class="price_icon_input">
                                                <input type="number" class="form-control " placeholder="Enter Volume" name="volume">
                                                <p>L</p>
                                            </div>
                                        <div class="invalid-feedback">This field is required</div></div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="comn-input-select ">
                                            <label class="form-label">Max. Load</label>
                                            <div class="price_icon_input">
                                                <input type="number" class="form-control " placeholder="Enter Max. Load" name="max_load">
                                                <p>Kg</p>
                                            </div>
                                        <div class="invalid-feedback">This field is required</div></div>
                                    </div>

                            
                                </div>
                            </div>
                        </div>

                
                    </div>





                    <div class="comn-input-select">
                        <label class="form-label">Other Information <span class="text-danger">*</span></label>
                   
                    <div id="other-info-container">
                        <div class="other-info-block">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="comn-input-select">
                                        
                                        <div class="btn-category">
                                            <label class="uplod-file" for="file-up-0">
                                                <i class="fa-solid fa-arrow-up-from-bracket"></i>
                                                <p>Upload image</p>
                                            </label>
                                            <input type="file" class="form-control required uplod-file-inpt" id="file-up-0" name="other_info[0][image]">
                                            <input type="text" class="form-control required" placeholder="Enter description here" name="other_info[0][description]">
                                            <a class="delete-outline-btn remove-info" href="javascript:void(0)">Delete</a>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <button type="button" id="add-info-btn" class="add-user">Add Another Information</button>
                    </div>
                    <div class="row marg-t-b">
                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="product-name" class="form-label">Keywords <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" placeholder="Enter Keywords" name="keywords">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="inputAddress" class="form-label">Related Product Variants (SKUs) :</label>
                                <select id="related-products" class="form-select" name="related_products[]" multiple>
                                    @foreach($products as $product)
                                    @php
                                        $img = ($product && $product->mainPhoto)
                                            ? asset('storage/' . $product->mainPhoto->image_path)
                                            : '';
                                    @endphp
                                
                                    
                                        <option value="{{ $product->id }}"
                                                data-img="{{ $img }}"
                                                >
                                            {{ $product->name }}
                                        </option>
                                   
                                @endforeach
                                </select>
                               
                            </div>
                        </div>
                    </div>
                    <div class="row marg-t-b">
                        <div class="col-md-12">
                            <div class="comn-input-select ">
                                <label for="inputAddress2" class="form-label">available models <span class="text-danger">*</span></label>
                                <div class="btn-category models-container flex-direc-column" id="">
                                    <div class="flex-main-avail-model w-100">
                                        <div class="model-row cat w-100">
                                            <input type="text" class="form-control mb-3 required" placeholder="enter title here" name="models[0][title]">
                                            <textarea class="form-control required" placeholder="Enter Description Here" style="height: 145px; resize:none;" name="models[0][description]"></textarea>
                                        </div>
                                    <a class="delete-outline-btn remove-model">Delete</a>
                                    </div>
                                </div>
                                <button type="button" id="add-model" class="add-user marg-t-30">Add another available model</button>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="comn-input-select mb-0">
                                <label for="upload-photo" class="form-label multiselect-form">Upload Photos <span class="text-danger">*</span></label>
                            </div>
                            <div class="upload-img-show d-flex">
                                <div class="main-inpt">
                                    <label for="upload-photo" class="upload-img-div">
                                        <i class="fa-solid fa-image"></i>
                                        <p>Add photos</p>
                                    </label>
                                    <input type="file" id="upload-photo" class="d-none " name="gallery_images[]" accept="image/*" multiple>
                                </div>
                                  <div id="image-previews" class="d-flex mt-2"></div>
                            </div>
                          
                            <p class="support-show m-width">Supports JPG, PNG, and WEBP formats</p>
                        </div>
                        <div class="col-md-3">
                            <div class="comn-input-select mb-0 ">
                                <label for="main-image" class="form-label multiselect-form">Upload product main Photo<span class="text-danger">*</span></label>
                            </div>
                            <div class="upload-img-show d-flex">
                                <div class="main-inpt">
                                    <label for="main-image" class="upload-img-div">
                                        <i class="fa-solid fa-image"></i>
                                        <p>Add  Photo</p>
                                    </label>
                                    <input type="file" id="main-image" class="d-none " name="main_image" accept="image/*">
                                </div>
                                <div id="main-image-preview" class="mt-2"></div>
                            </div>
                            <p class="support-show m-width">Supports JPG, PNG, and WEBP formats</p>
                        </div>
                        <div class="col-md-3">
                            <div class="comn-input-select mb-0">
                                <label for="info-image" class="form-label multiselect-form">Upload information Photo <span class="text-danger">*</span></label>
                            </div>
                            <div class="upload-img-show d-flex">
                                <div class="main-inpt">
                                    <label for="info-image" class="upload-img-div">
                                        <i class="fa-solid fa-image"></i>
                                        <p>Add  Photo</p>
                                    </label>
                                    <input type="file" id="info-image" class="d-none " name="info_image" accept="image/*">
                                </div>
                                <div id="info-image-preview" class="mt-2"></div>
                            </div>
                            <p class="support-show m-width">Supports JPG, PNG, and WEBP formats</p>
                        </div>
                        <div class="col-md-3">
                            <div class="comn-input-select mb-0">
                                <label for="home-image" class="form-label multiselect-form">Upload Product Preview Photo <span class="text-danger">*</span></label>
                            </div>
                            <div class="upload-img-show d-flex">
                                <div class="main-inpt">
                                    <label for="home-image" class="upload-img-div">
                                        <i class="fa-solid fa-image"></i>
                                        <p>Add  Photo</p>
                                    </label>
                                    <input type="file" id="home-image" class="d-none " name="home_image" accept="image/*">
                                </div>
                                <div id="home-image-preview" class="mt-2"></div>
                            </div>
                            <p class="support-show m-width">Supports JPG, PNG, and WEBP formats</p>
                        </div>
                        <div class="col-12">
                            <div class="upper-main-btn-last-comn d-flex btn-main-upload-edit">
                                <button type="submit" class="add-user">Add product</button>
                                <a href="{{ route('admin.products.index') }}" class="cancel-btn">Cancel</a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
<script>
$(document).ready(function() {
    function initializeValidation() {
        $('.required').each(function() {
            const $input = $(this);
            const $formGroup = $input.closest('.comn-input-select');
            let fieldName = '';
            
            // Get the label text for more specific error messages
            const label = $formGroup.find('label').text().trim();
            if (label.includes('Product Name')) {
                fieldName = 'product name';
            } else if (label.includes('Product category')) {
                fieldName = 'product category';
            } else if (label.includes('Product brand')) {
                fieldName = 'product brand';
            } else if (label.includes('description')) {
                fieldName = 'description';
            } else if (label.includes('quantity')) {
                fieldName = 'quantity';
            } else if (label.includes('SKU')) {
                fieldName = 'SKU';
            } else if (label.includes('Status')) {
                fieldName = 'status';
            } else if (label.includes('length')) {
                fieldName = 'length';
            } else if (label.includes('width')) {
                fieldName = 'width';
            } else if (label.includes('height')) {
                fieldName = 'height';
            } else if (label.includes('Volume')) {
                fieldName = 'volume';
            } else if (label.includes('Max. Load')) {
                fieldName = 'max load';
            } else if (label.includes('Keywords')) {
                fieldName = 'keywords';
            } else if (label.includes('title')) {
                fieldName = 'model title';
            } else if (label.includes('Description')) {
                fieldName = 'model description';
            } else if (label.includes('Upload Photos')) {
                fieldName = 'product photos';
            } else if (label.includes('main Photo')) {
                fieldName = 'main product photo';
            } else if (label.includes('information Photo')) {
                fieldName = 'information photo';
            } else if (label.includes('Preview Photo')) {
                fieldName = 'preview photo';
            } else if (label.includes('size/variation')) {
                fieldName = 'size/variation';
            } else if (label.includes('Product Weight')) {
                fieldName = 'product weight';
            } else {
                fieldName = 'this field';
            }
            
            // Clean up field name (remove asterisks and extra spaces)
            fieldName = fieldName.replace(/\*+/g, '').trim();
            
            if (!$formGroup.find('.invalid-feedback').length) {
                $formGroup.append(`<div class="invalid-feedback">Please enter ${fieldName}</div>`);
            } else {
                $formGroup.find('.invalid-feedback').text(`Please enter ${fieldName}`);
            }
        });
        
        $('input[name*="[sku]"]').each(function() {
            const $input = $(this);
            const $formGroup = $input.closest('.comn-input-select');
            
            if (!$formGroup.find('.invalid-feedback').length) {
                $input.after(`<div class="invalid-feedback">Please enter a unique SKU</div>`);
            } else {
                $formGroup.find('.invalid-feedback').text('Please enter a unique SKU');
            }
        });
    }
    
    $('form').on('submit', function(e) {

        e.preventDefault();
        let isValid = true;
        const $form = $(this);
        
        $form.removeClass('was-validated');
        $('.is-invalid').removeClass('is-invalid');
        $('.invalid-feedback').hide();
        
        $('.required:visible').each(function() {
            const $input = $(this);
            const value = $input.val();
            const $formGroup = $input.closest('.comn-input-select');
            let fieldName = 'this field';

            const label = $formGroup.find('label').text().trim();
            if (label.includes('Product Name')) {
                fieldName = 'product name';
            } else if (label.includes('Product category')) {
                fieldName = 'product category';
            } else if (label.includes('Product brand')) {
                fieldName = 'product brand';
            } else if (label.includes('description')) {
                fieldName = 'description';
            } else if (label.includes('quantity')) {
                fieldName = 'quantity';
            } else if (label.includes('SKU')) {
                fieldName = 'SKU';
            } else if (label.includes('Status')) {
                fieldName = 'status';
            } else if (label.includes('length')) {
                fieldName = 'length';
            } else if (label.includes('width')) {
                fieldName = 'width';
            } else if (label.includes('height')) {
                fieldName = 'height';
            } else if (label.includes('Volume')) {
                fieldName = 'volume';
            } else if (label.includes('Max. Load')) {
                fieldName = 'max load';
            } else if (label.includes('Keywords')) {
                fieldName = 'keywords';
            } else if (label.includes('title')) {
                fieldName = 'model title';
            } else if (label.includes('Description')) {
                fieldName = 'model description';
            } else if (label.includes('Upload Photos')) {
                fieldName = 'product photos';
            } else if (label.includes('main Photo')) {
                fieldName = 'main product photo';
            } else if (label.includes('information Photo')) {
                fieldName = 'information photo';
            } else if (label.includes('Preview Photo')) {
                fieldName = 'preview photo';
            } else if (label.includes('size/variation')) {
                fieldName = 'size/variation';
            } else if (label.includes('Product Weight')) {
                fieldName = 'product weight';
            } else {
                fieldName = 'this field';
            }


            // if (!value || value.trim() === '') {
            //     $input.addClass('is-invalid');

            //     const $feedback = $input.closest('.comn-input-select').find('.invalid-feedback');
            //     if (!$feedback.length) {
            //         $input.after(`<div class="invalid-feedback">This field is required</div>`);
            //     } else {
            //         $feedback.show();
            //     }

            //     isValid = false;
            // }

            if (!value || value.trim() === '') {
                $input.addClass('is-invalid');
                const $feedback = $formGroup.find('.invalid-feedback');
                $feedback.text(`Please enter ${fieldName}`).show();
                isValid = false;
            }
        });
       
        let isVariableProduct = !$('#inner-add-color').hasClass('d-none');
        console.log(isVariableProduct)
        if(isVariableProduct){

     
        const skus = new Set();
        $('input[name*="[sku]"]').each(function() {
            const $input = $(this);
            const sku = $input.val().trim();
            
            if (!sku) {
                $input.addClass('is-invalid');
                $input.closest('.comn-input-select').find('.invalid-feedback').show();
                isValid = false;
            } else if (skus.has(sku)) {
                $input.addClass('is-invalid');
                $input.closest('.comn-input-select').find('.invalid-feedback').text('SKU must be unique').show();
                isValid = false;
            } else {
                skus.add(sku);
            }
        });
        
        const sizes = new Set();
        $('.size-select').each(function() {
            const $select = $(this);
            const size = $select.val();
            
            if (!size) {
                $select.addClass('is-invalid');
                $select.closest('.comn-input-select').find('.invalid-feedback').show();
                isValid = false;
            } else if (sizes.has(size)) {
                $select.addClass('is-invalid');
                $select.closest('.comn-input-select').find('.invalid-feedback').text('Size must be unique per product').show();
                isValid = false;
            } else {
                sizes.add(size);
            }
        });
    }else{
        const simpleFields = ['weight', 'status', 'length', 'width', 'height', 'volume', 'max_load'];
        simpleFields.forEach(field => {
            const $input = $(`[name="${field}"]`);
            if ($input.length && $input.hasClass('required') && !$input.val()) {
                $input.addClass('is-invalid');
                $input.closest('.comn-input-select').find('.invalid-feedback').show();
                isValid = false;
            }
        });
    }
        
        $('.model-row').each(function() {
            const $row = $(this);
            const title = $row.find('input[name*="[title]"]').val().trim();
            const desc = $row.find('textarea[name*="[description]"]').val().trim();
            
            if (!title) {
                $row.find('input[name*="[title]"]').addClass('is-invalid')
                    .closest('.comn-input-select').find('.invalid-feedback').text('Title is required').show();
                isValid = false;
            }
            
            if (!desc) {
                $row.find('textarea[name*="[description]"]').addClass('is-invalid')
                    .closest('.comn-input-select').find('.invalid-feedback').text('Description is required').show();
                isValid = false;
            }
        });

        
        
        if (isValid) {
            $form.unbind('submit').submit();
        } else {
            $('html, body').animate({
                scrollTop: $('.is-invalid').first().offset().top - 100
            }, 500);
            
            $form.addClass('was-validated');
        }
    });
    
    $(document).on('input blur', 'input[name*="[sku]"]', function () {
        const $input = $(this);
        const sku = $input.val().trim();
        const $feedback = $input.closest('.comn-input-select').find('.invalid-feedback');
        const currentName = $input.attr('name');
        let error = '';

        if (!sku) {
            error = 'SKU is required';
        } else {
            let isDuplicate = false;
            $('input[name*="[sku]"]').not(`[name="${currentName}"]`).each(function () {
                if ($(this).val().trim() === sku) {
                    isDuplicate = true;
                    return false;
                }
            });
            if (isDuplicate) {
                error = 'SKU must be unique';
            }
        }

        if (error) {
            $input.addClass('is-invalid');
            $feedback.text(error).show();
        } else {
            $input.removeClass('is-invalid');
            $feedback.hide();
        }
    });
    $(document).on('blur', '.required', function () {
        const $input = $(this);
        if ($input.is('input[name*="[sku]"]')) return; // skip SKU fields

        const $feedback = $input.closest('.comn-input-select').find('.invalid-feedback');
        if (!$input.val().trim()) {
            $input.addClass('is-invalid');
            $feedback.show();
        } else {
            $input.removeClass('is-invalid');
            $feedback.hide();
        }
    });
    
    $(document).on('change', '.size-select', function() {
        const $select = $(this);
        const size = $select.val();
        const $feedback = $select.closest('.comn-input-select').find('.invalid-feedback');
        
        if (!size) {
            $select.addClass('is-invalid');
            console.log('invalid size');
            $feedback.text('Size is required').show();
        } else {
            let isDuplicate = false;
            const currentName = $select.attr('name');
            
            $('.size-select').not(`[name="${currentName}"]`).each(function() {
                if ($(this).val() === size) {
                    isDuplicate = true;
                    return false; // break loop
                }
            });
            
            if (isDuplicate) {
                $select.addClass('is-invalid');
                console.log('invalid size');
                $feedback.text('Size must be unique per product').show();
            } else {
                $select.removeClass('is-invalid');
                console.log('valid size');
                $feedback.hide();
            }
        }
    });
    
    initializeValidation();
    
    $(document).on('click', '#add-variation', function() {
        setTimeout(initializeValidation, 100);
    });
    
    $(document).on('click', '#add-model', function() {
        setTimeout(initializeValidation, 100);
    });

    $(document).on('click', '.restore-colors', function() {
        setTimeout(initializeValidation, 100);
    });
    
    $(document).on('click', '#add-info-btn', function() {
        setTimeout(initializeValidation, 100);
    });

    $(document).on('change', '#category', function () {
        setTimeout(initializeValidation, 100);
    });
    
});

    $(document).ready(function() {

        function toggleRemoveButton() {
            if ($('.variation-block').length > 1) {
                $('.remove-variation').show();
            } else {
                $('.remove-variation').hide();
            }
        }
        toggleRemoveButton();
    

        $('#related-products').select2({
            templateResult: formatSku,
            templateSelection: formatSku,
            maximumSelectionLength: 3,
            escapeMarkup: m => m
        });

        function formatSku(option) {
            if (!option.id) return option.text;

            const img = $(option.element).data('img');
            const sku = $(option.element).data('sku') || option.text;

            return `<div style="display:flex; align-items:center;">
                        ${img ? `<img src="${img}" style="width:30px;height:30px;object-fit:cover;margin-right:10px;">` : ''}
                        <span>${sku}</span>
                    </div>`;
        }
        let variationCounter = 1;

        $('#add-variation').click(function () {
        const $original = $('.variation-block').first();
        const $clone = $original.clone();

        $clone.find('input, select').each(function () {
            const name = $(this).attr('name');
            if (name) {
                const updatedName = name.replace(/\[0\]/g, `[${variationCounter}]`);
                $(this).attr('name', updatedName);
                
                if (name.includes('[colors]') && name.includes('[color_id]')) {
                    const colorId = name.match(/\[colors\]\[(\d+)\]/)[1];
                    $(this).val(colorId);
                }
            }
            if ($(this).is('input:not([type="hidden"])')) {
                $(this).val('');
            }
        });

        // Add restore button
        if ($clone.find('.restore-colors').length === 0) {
            $clone.find('#removeVariationBtn').before(`
                <button type="button" class="btn btn-secondary restore-colors">Restore Colors</button>
            `);
        }

        $('#variation-container').append($clone);
        toggleRemoveButton();
        variationCounter++;
    });

    $(document).on('click', '.restore-colors', function() {
        const $variationBlock = $(this).closest('.variation-block');
        const index = $('.variation-block').index($variationBlock);
        const selectedOption = $('#category').find('option:selected');
        const colorIds = selectedOption.data('color_ids') || [];
        const allColors = @json($colors);
        
        const $colorRow = $variationBlock.find('.comm_slec_size_row');
        const existingColors = $colorRow.find('input[name*="[color_id]"]').map(function() {
            return $(this).val();
        }).get();
        
        allColors.forEach(color => {
            if (colorIds.includes(color.id.toString()) && !existingColors.includes(color.id.toString())) {
                const block = `
                    <div class="comm_slec_size_col">
                        <div class="clr_box" style="background-color: white; color: black">
                            <div class="cross remove-color"><i class="fa-solid fa-xmark"></i></div>
                            ${color.name}
                            <input type="hidden" name="variations[${index}][colors][${color.id}][color_id]" value="${color.id}">
                        </div>
                        <div class="comn-input-select">
                            <input type="text" class="form-control required" placeholder="Enter Quantity" name="variations[${index}][colors][${color.id}][quantity]">
                        </div>
                        <div class="comn-input-select">
                            <input type="text" class="form-control required" placeholder="Enter SKU" name="variations[${index}][colors][${color.id}][sku]">
                        </div>
                    </div>`;
                $colorRow.append(block);
            }
        });
    });

    $(document).on('click', '.remove-variation', function () {
        if ($('.variation-block').length > 1) {
            $(this).closest('.variation-block').remove();
            toggleRemoveButton();
        }
    });
    
   
    
    $(document).on('click', '.remove-color', function() {
        $(this).closest('.comm_slec_size_col').remove();
    });
    
    let modelCounter = 1;
    
    $('#add-model').click(function() {
        const newRow = `
        
                               <div class="flex-main-avail-model w-100">
                                        <div class="model-row cat w-100">
                                            <input type="text" class="form-control mb-3" placeholder="enter title here" name="models[${modelCounter}][title]">
            <textarea class="form-control" placeholder="Enter Description Here" style="height: 145px; resize:none;" name="models[${modelCounter}][description]"></textarea>
          
                                        </div>
                                          <a class="delete-outline-btn remove-model">Delete</a>
                                        </div>
                                   
                                
        
        
        `;
        
        $('.models-container').append(newRow);
        modelCounter++;
    });
    
    $(document).on('click', '.remove-model', function() {
        $(this).closest('.flex-main-avail-model').remove();
    });
    
    let infoCounter = 1;

    $('#add-info-btn').click(function () {
    const $original = $('.other-info-block').first();
    const $clone = $original.clone();

    $clone.find('input').each(function () {
        let name = $(this).attr('name');
        if (name) {
            let updatedName = name.replace(/\[0\]/g, `[${infoCounter}]`);
            $(this).attr('name', updatedName);
        }
        $(this).val('');
    });

    const uniqueId = 'file-up-' + infoCounter;
    $clone.find('input[type="file"]').attr('id', uniqueId);
    $clone.find('label.uplod-file').attr('for', uniqueId);

    $clone.find('img.preview-image, .remove-preview').remove();

    $('#other-info-container').append($clone);
    infoCounter++;
});

    $(document).on('click', '.remove-info', function () {
        if ($('.other-info-block').length > 1) {
            $(this).closest('.other-info-block').remove();
        }
    });



    $('#upload-photo').change(function(e) {
        const files = e.target.files;
        const previewContainer = $('#image-previews');
        previewContainer.empty();
        
        for (let i = 0; i < files.length; i++) {
            const reader = new FileReader();
            reader.onload = function(event) {
                previewContainer.append(`
                <div class="preview-item show-one-img p-0" style="position: relative;">
                    <img src="${event.target.result}">
                 
                     <div class="cross remove-preview" data-index="${i}">
                                        <i class="fa-solid fa-xmark"></i>
                                    </div>
                </div>`);
            }
            reader.readAsDataURL(files[i]);
        }
    });
    
    $(document).on('click', '.remove-preview', function() {
        const index = $(this).data('index');
        const input = $('#upload-photo')[0];
        const files = Array.from(input.files);
        
        files.splice(index, 1);
        
        const dataTransfer = new DataTransfer();
        files.forEach(file => dataTransfer.items.add(file));
        input.files = dataTransfer.files;
        
        $('#upload-photo').trigger('change');
    });
    
    $('#main-image').change(function(e) {
        const file = e.target.files[0];
        const previewContainer = $('#main-image-preview');
        previewContainer.empty();
        
        if (file) {
            const reader = new FileReader();
            reader.onload = function(event) {
                previewContainer.html(`
                <div class="preview-item show-one-img p-0" style="position: relative; ">
                    <img src="${event.target.result}">
                    <div class="cross remove-preview-main" >
                                        <i class="fa-solid fa-xmark"></i>
                                    </div>
                </div>`);
            }
            reader.readAsDataURL(file);
        }
    });
    
    $(document).on('click', '.remove-preview-main', function() {
        $('#main-image').val('');
        $('#main-image-preview').empty();
    });
    
    $('#info-image').change(function(e) {
        const file = e.target.files[0];
        const previewContainer = $('#info-image-preview');
        previewContainer.empty();
        
        if (file) {
            const reader = new FileReader();
            reader.onload = function(event) {
                previewContainer.html(`
                <div class="preview-item show-one-img p-0" style="position: relative; ">
                    <img src="${event.target.result}" >
                    <div class="cross remove-preview-info" >
                                        <i class="fa-solid fa-xmark"></i>
                                    </div>
                </div>`);
            }
            reader.readAsDataURL(file);
        }
    });
    $('#home-image').change(function(e) {
        const file = e.target.files[0];
        const previewContainer = $('#home-image-preview');
        previewContainer.empty();
        
        if (file) {
            const reader = new FileReader();
            reader.onload = function(event) {
                previewContainer.html(`
                <div class="preview-item show-one-img p-0" style="position: relative; ">
                    <img src="${event.target.result}" >
                    <div class="cross remove-preview-home" >
                                        <i class="fa-solid fa-xmark"></i>
                                    </div>
                </div>`);
            }
            reader.readAsDataURL(file);
        }
    });

$(document).on('change', '.uplod-file-inpt', function () {
    let input = this;
    let wrapper = $(input).closest('.btn-category');
    wrapper.find('.preview-wrapper').remove(); // remove previous preview if exists

    if (input.files && input.files[0]) {
        let reader = new FileReader();
        reader.onload = function (e) {
            let previewWrapper = $('<div class="preview-wrapper" style="margin-top:10px;"></div>');
            let img = $(' <img class="preview-image">').attr('src', e.target.result);
            let btn = $('<button type="button" class="cross remove-preview"><i class="fa-solid fa-xmark"></i></button>');

            btn.on('click', function () {
                $(input).val('');
                previewWrapper.remove();
            });

            previewWrapper.append(img).append(btn);
            wrapper.append(previewWrapper);
        };
        reader.readAsDataURL(input.files[0]);
    }
});

    
    $(document).on('click', '.remove-preview-info', function() {
        $('#info-image').val('');
        $('#info-image-preview').empty();
    });
    $(document).on('click','.remove-preview-home',function(){
        $('#home-image').val('');
        $('#home-image-preview').empty();
    })
});


</script>

<script>
    const allSizes = @json($sizes);
    const allVariations = @json($variations);
    

    $(document).on('change', '#category', function () {
        const selectedOption = $(this).find('option:selected');
        const sizeIds = selectedOption.data('size_ids') || [];
        const variationIds = selectedOption.data('variation_ids') || [];
        const colorIds = selectedOption.data('color_ids') || [];
        const allColors = @json($colors);

        if (sizeIds.length === 0 && variationIds.length === 0) {
            $('#non-variant-block').removeClass('d-none').find(':input').prop('disabled', false);
            $('#inner-add-color').addClass('d-none').find(':input').prop('disabled', true);

            return; // Exit the whole handler early
        } 

        $('.variation-block').each(function (index) {
            const $variationBlock = $(this);
            const $sizeSelect = $variationBlock.find('.size-select');
            
            $sizeSelect.empty().append('<option selected>Select Size/Variation</option>');
            
            if (sizeIds.length > 0) {
                allSizes.forEach(size => {
                    if (sizeIds.includes(size.id.toString())) {
                        $sizeSelect.append(`<option value="${size.id}">${size.name}</option>`);
                    }
                });
                $('#inner-add-color').removeClass('d-none').find(':input').prop('disabled', false);
                $('#non-variant-block').addClass('d-none').find(':input').prop('disabled', true);
                
            } else if (variationIds.length > 0) {
                allVariations.forEach(variation => {
                    if (variationIds.includes(variation.id.toString())) {
                        $sizeSelect.append(`<option value="${variation.id}">${variation.name}</option>`);
                    }
                });
                $('#inner-add-color').removeClass('d-none').find(':input').prop('disabled', false);
                 $('#non-variant-block').addClass('d-none').find(':input').prop('disabled', true);
            }

            const $colorRow = $variationBlock.find('.comm_slec_size_row');
            $colorRow.empty();

            allColors.forEach(color => {
                if (colorIds.includes(color.id.toString())) {
                    const block = `
                        <div class="comm_slec_size_col">
                            <div class="clr_box" style="background-color: white; color: black">
                                <div class="cross remove-color"><i class="fa-solid fa-xmark"></i></div>
                                ${color.name}
                                <input type="hidden" name="variations[${index}][colors][${color.id}][color_id]" value="${color.id}">
                            </div>
                            <div class="comn-input-select">
                                <input type="text" class="form-control required" placeholder="Enter Quantity" name="variations[${index}][colors][${color.id}][quantity]">
                            </div>
                            <div class="comn-input-select">
                                <input type="text" class="form-control required" placeholder="Enter SKU" name="variations[${index}][colors][${color.id}][sku]">
                            </div>
                        </div>`;
                    $colorRow.append(block);
                }
            });
        });

        $('#inner-add-color').removeClass('d-none').find(':input').prop('disabled', false);

});


</script>