@extends('layouts.admin')
@section('content')

@if (session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
        @if (session('error_details'))
            <ul>
                @foreach (session('error_details') as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        @endif
    </div>
@endif

       <style>
        h2#heading-roof-box {
                padding-right: 30px;
            }

            h2#heading-roof-box a.edit-btn-eye {
                margin-right: 5px;
            }
            h2#heading-roof-box {
    padding-right: 30px;
}

h2#heading-roof-box a.edit-btn-eye {
    margin-right: 5px;
}

.quantity-info {
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.rented-count {
    font-size: 12px;
    color: #e74c3c;
    font-weight: 500;
}

.available-count {
    font-size: 12px;
    color: #27ae60;
    font-weight: 500;
}

.low-stock {
    color: #f39c12;
    font-weight: bold;
}

.out-of-stock {
    color: #e74c3c;
    font-weight: bold;
}
       </style>
        
            <div class="col-9 main-dash-left">

                <div class="comm_head_top">
                    <div class="name-head">
                        <h2>Product Analytics</h2>
                        <div class="d-flex comm_head_top_right">
                          
                            <div class="sownload-cv-pdf">
                                <button class="download-pdf" id="download-pdf">Download PDF</button>
                                <button id="download-csv" class="download-pdf">Download CSV</button>
                            </div>
                            <select class="form-select select-main-head" aria-label="Time period filter">
                                <option value="year" {{ request('time_period') == 'year' ? 'selected' : '' }}>Year</option>
                                <option value="month" {{ request('time_period') == 'month' ? 'selected' : '' }}>Month</option>
                                <option value="week" {{ request('time_period') == 'week' ? 'selected' : '' }}>Week</option>
                                <option value="day" {{ request('time_period') == 'day' ? 'selected' : '' }}>Day</option>
                            </select>
                        </div>
                    </div>

                    <div class="cards-dashboard">
                        <div class="row row-gap-3">
                            <div class="col-lg-3 col-md-6">
                                <div class="inner-dashboard-card back-green">
                                    <div class="ing-sec-acrd-dash">
                                        <figure class="logo-card"><img src="{{asset('admin/images/total.png')}}" alt=""></figure>
                                        <div class="main-card-analy d-flex">
                                            <div class="text-disc-card">
                                                <p>Number of Active Products</p>
                                                <h4>{{ $totalProducts }}</h4>
                                            </div>
                                            <figure class="img-graph">
                                            <img src="{{asset('admin/images/green-line.png')}}" alt="">
                                            </figure>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6">
                                <div class="inner-dashboard-card back-purple">
                                    <div class="ing-sec-acrd-dash">
                                    <figure class="logo-card"><img src="{{asset('admin/images/return.png')}}" alt="">
                                        </figure>
                                        <div class="main-card-analy d-flex">
                                            <div class="text-disc-card">
                                                <p>Number Of Inactive Products</p>
                                                <h4>{{ $inactiveProducts }}</h4>
                                            </div>
                                            
                                            <figure class="img-graph">
                                            <img src="{{asset('admin/images/white-line.png')}}" alt="">
                                            </figure>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6">
                                <div class="inner-dashboard-card back-yellow">
                                    <div class="ing-sec-acrd-dash">
                                    <figure class="logo-card"><img src="{{asset('admin/images/top.png')}}" alt=""></figure>
                                        <div class="main-card-analy d-flex">
                                            <div class="text-disc-card">
                                                <p>Number Of Product Categories</p>
                                                <h4>{{ $totalProductCategories }}</h4>
                                            </div>
                                            <figure class="img-graph">
                                            <img src="{{asset('admin/images/orange-line.png')}}" alt="">
                                            </figure>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6">
                                <div class="inner-dashboard-card back-parrot">
                                    <div class="ing-sec-acrd-dash">
                                    <figure class="logo-card"><img src="{{asset('admin/images/lost.png')}}" alt=""></figure>
                                        <div class="main-card-analy d-flex">
                                            <div class="text-disc-card">
                                                <p>Number Of Bundle Products</p>
                                                <h4>{{ $bundleProducts }}</h4>
                                            </div>
                                            <figure class="img-graph">
                                            <img src="{{asset('admin/images/parot-line.png')}}" alt="">
                                            </figure>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>



                    <div class="notifi-list d-flex">
                        <h6>Product Management</h6>
                        <div class="dropdowns-inner-list d-flex">
                            <div class="dropdowns-inner-list">
                                <div class="icon-search-main white_bg">
                                    <i class="fa-solid fa-magnifying-glass"></i>
                                    <input aria-describedby="passwordHelpBlock" placeholder="Search For Products"
                                        type="text" id="inputPassword5" class="form-control" value="">
                                </div>
                            </div>
                            <div class="filter-main-div">
                                <p class="lable-filt">Filter:</p>
                                <div class="dropdown">
                                    <button class="filter-btn dropdown-toggle" type="button" id="categoryFilterDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="fa-solid fa-filter"></i> Filter
                                    </button>
                                    <ul class="dropdown-menu" aria-labelledby="categoryFilterDropdown">
                                        <li><a class="dropdown-item filter-category" href="#" data-category="all">All Categories</a></li>
                                        @foreach($groupedByCategory as $categoryName => $products)
                                            @php $categoryId = \Illuminate\Support\Str::slug($categoryName); @endphp
                                            <li><a class="dropdown-item filter-category" href="#" data-category="{{ $categoryId }}">{{ $categoryName }}</a></li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                            
                            <a class="add-notification-btn" id="download-csv-new">Download Product CSV</a>
                            {{-- <a class="add-notification-btn" id="download-template">Download Template</a> --}}
                            <button type="button" class="add-notification-btn" data-bs-toggle="modal" data-bs-target="#uploadCsvModal">Upload Product CSV</button>
                            <a class="add-notification-btn" href="{{route('admin.products.create')}}">add Product</a>
                        </div>
                    </div>
                    


                    <div class="accordion product_accordion" id="accordionExample">
                  
                       
                        @foreach($groupedByCategory as $categoryName => $products)
                            @php $categoryId = \Illuminate\Support\Str::slug($categoryName); @endphp
                            @php
                                        $product = $products->first(); 
                                    @endphp
                            <div class="accordion-item">
                                <h2 class="accordion-header aco-head-flex flex-edit-btn" id="heading-{{ $categoryId }}">

                                    <button class="accordion-button comm_heading_20" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapse-{{ $categoryId }}" aria-expanded="true"
                                            aria-controls="collapse-{{ $categoryId }}">
                                        {{ $categoryName }}
                                       
                                    </button>
                                    {{-- <a class="edit-btn-eye" href="{{ route('admin.products.edit', $product->id) }}">
                                        <i class="fa-solid fa-pen-to-square"></i>
                                    </a> --}}
                                     <a class="edit-btn-eye" href="{{ route('admin.products.quick-edit', $product->id) }}" title="Quick Edit">
                                        <i class="fa-solid fa-bolt"></i>
                                    </a>

                                    <a class="edit-btn-eye" href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#editProductModal" data-product-id="{{ $product->id }}">
                                        <i class="fa-solid fa-pen-to-square"></i>
                                    </a>
                                    <button type="button" class="delete-btn-eye" onclick="openDeleteModal('{{ $product->id }}')">
                                        <i class="fa-solid fa-trash"></i>
                                    </button>
                                  
                                    
                                </h2>
                                <div id="collapse-{{ $categoryId }}" class="accordion-collapse collapse show"
                                    aria-labelledby="heading-{{ $categoryId }}" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <div class="notification-table pt-0">
                                            <table class="table">
                                                <thead>
                                                    <tr class="head-class-td">
                                                        <th>Nr.</th>
                                                        <th>SKU</th>
                                                        <th>Product Name</th>
                                                        <th>Size/Variation</th>
                                                        <th>Color</th>
                                                        <th>Total Quantity</th>
                                                        <th>Remaining Quantity</th>
                                                        <th>Dimensions</th>
                                                        <th>Weight</th>
                                                        <th>Volume</th>
                                                        <th>Action</th>
                                                        <th>Status</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($products as $product)
                                                    <?php $i= 1; ?>
                                                    @php $i = 1; @endphp

                                                        @if($product->variations->isEmpty())
                                                            <tr>
                                                                <td>{{ $i++ }}</td>
                                                                <td>{{ $product->sku ?? '-' }}</td>
                                                                <td>{{ $product->name }}</td>
                                                                <td>-</td>
                                                                <td>{{ $product->color->name ?? '-' }}</td>
                                                                {{-- <td>
                                                                    <div class="quantity-info">
                                                                        <span>{{ $product->quantity ?? 0 }}</span>
                                                                        @if(isset($rentedCounts['product'][$product->id]))
                                                                        <span class="rented-count">Rented: {{ $rentedCounts['product'][$product->id] }}</span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="quantity-info">
                                                                        <span @class([
                                                                            'low-stock' => $product->total_quantity > 0 && $product->total_quantity <= 2,
                                                                            'out-of-stock' => $product->total_quantity <= 0
                                                                        ])>
                                                                            {{ $product->total_quantity ?? 0 }}
                                                                        </span>
                                                                        
                                                                    </div>
                                                                </td> --}}
                                                                <td>N/A</td>
                                                                <td>N/A</td>
                                                                <td>{{ $product->length }} x {{ $product->width }} x {{ $product->height }}</td>
                                                                <td>{{ $product->weight ?? '—' }}</td>
                                                                <td>{{ $product->volume ?? '—' }}</td>
                                                                <td>
                                                                    <div class="upper-delete-btns d-flex">
                                                                        <a class="view-btn-eye" href="{{ route('admin.products.show', $product->id) }}">
                                                                            <i class="fa-solid fa-eye"></i>
                                                                        </a>
                                                                        <form method="POST" action="{{ route('admin.products.destroy', $product->id) }}">
                                                                            @csrf @method('DELETE')
                                                                            <button type="submit" class="delete-btn-eye" onclick="return confirm('Delete this product?')">
                                                                                <i class="fa-solid fa-trash"></i>
                                                                            </button>
                                                                        </form>
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <label class="switch custm_toggle_switch">
                                                                        <input type="checkbox" class="variant-status-toggle"
                                                                            data-type="product"
                                                                            data-variant-id="{{ $product->id }}"
                                                                            {{ $product->status === 'in_stock' ? 'checked' : '' }}>
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                        @else
                                                            @foreach($product->variations as $variation)
                                                                @php $firstRow = true; @endphp
                                                                @if(!$variation->options->isEmpty())
                                                                @foreach($variation->options as $option)
                                                                    <tr>
                                                                        <td>{{ $i++ }}</td>
                                                                        <td>{{ $option->sku }}</td>
                                                                        <td>{{ $product->name }}</td>
                                                                        <td>{{ $variation->size->name ?? $variation->variation->name ?? '-' }}</td>
                                                                        <td>{{ $option->color->name ?? '-' }}</td>
                                                                        <td>
                                                                            <div class="quantity-info">
                                                                                <span>{{ $option->quantity ?? 0 }}</span>
                                                                                @if(isset($rentedCounts['option'][$option->id]))
                                                                                <span class="rented-count">Rented: {{ $rentedCounts['option'][$option->id] }}</span>
                                                                                @endif
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="quantity-info">
                                                                                <span @class([
                                                                                    'low-stock' => $option->total_quantity > 0 && $option->total_quantity <= 2,
                                                                                    'out-of-stock' => $option->total_quantity <= 0
                                                                                ])>
                                                                                    {{ $option->total_quantity ?? $option->quantity }}
                                                                                </span>
                                                                               
                                                                            </div>
                                                                        </td>
                                                                        <td>{{ $variation->length }} x {{ $variation->width }} x {{ $variation->height }}</td>
                                                                        <td>{{ $variation->weight ?? '—' }}</td>
                                                                        <td>{{ $variation->volume ?? '—' }}</td>
                                                                        <td>
                                                                            <div class="upper-delete-btns d-flex">
                                                                                
                                                                                <a class="view-btn-eye" href="{{ route('admin.products.variant.show', ['product' => $product->id, 'variant' => $variation->id, 'option' => $option->id ?? null]) }}">
                                                                                    <i class="fa-solid fa-eye"></i>
                                                                                </a>
                                                                               
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            @if($firstRow)
                                                                                <label class="switch custm_toggle_switch">
                                                                                    <input type="checkbox" class="variant-status-toggle"
                                                                                         data-type="variant"
                                                                                        data-variant-id="{{ $variation->id }}"
                                                                                        {{ $variation->status === 'in_stock' ? 'checked' : '' }}>
                                                                                    <span class="slider round"></span>
                                                                                </label>
                                                                                @php $firstRow = false; @endphp
                                                                            @endif
                                                                        </td>
                                                                    </tr>
                                                                @endforeach
                                                                @else
                                                                    <tr>
                                                                        <td>{{ $i++ }}</td>
                                                                        <td>{{ $variation->sku ?? '-' }}</td>
                                                                        <td>{{ $product->name }}</td>
                                                                        <td>{{ $variation->size->name ?? $variation->variation->name ?? '-' }}</td>
                                                                        <td>{{ $variation->color->name ?? '-' }}</td>
                                                                        <td>
                                                                            <div class="quantity-info">
                                                                                <span>{{ $variation->quantity ?? 0 }}</span>
                                                                                @if(isset($rentedCounts['variation'][$variation->id]))
                                                                                <span class="rented-count">Rented: {{ $rentedCounts['variation'][$variation->id] }}</span>
                                                                                @endif
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="quantity-info">
                                                                                <span @class([
                                                                                    'low-stock' => $variation->total_quantity > 0 && $variation->total_quantity <= 2,
                                                                                    'out-of-stock' => $variation->total_quantity <= 0
                                                                                ])>
                                                                                    {{ $variation->total_quantity ?? $variation->quantity }}
                                                                                </span>
                                                                                @if(isset($rentedCounts['variation'][$variation->id]))
                                                                                <span class="available-count">
                                                                                    Available: {{ $variation->quantity - $rentedCounts['variation'][$variation->id] }}
                                                                                </span>
                                                                                @endif
                                                                            </div>
                                                                        </td>
                                                                        <td>{{ $variation->length }} x {{ $variation->width }} x {{ $variation->height }}</td>
                                                                        <td>{{ $variation->weight ?? '—' }}</td>
                                                                        <td>{{ $variation->volume ?? '—' }}</td>
                                                                        <td>
                                                                            <div class="upper-delete-btns d-flex">
                                                                                
                                                                                <a class="view-btn-eye" href="{{ route('admin.products.variant.show', ['product' => $product->id, 'variant' => $variation->id, 'option' => null]) }}">
                                                                                    <i class="fa-solid fa-eye"></i>
                                                                                </a>
                                                                               
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            @if($firstRow)
                                                                                <label class="switch custm_toggle_switch">
                                                                                    <input type="checkbox" class="variant-status-toggle"
                                                                                         data-type="variant"
                                                                                        data-variant-id="{{ $variation->id }}"
                                                                                        {{ $variation->status === 'in_stock' ? 'checked' : '' }}>
                                                                                    <span class="slider round"></span>
                                                                                </label>
                                                                                @php $firstRow = false; @endphp
                                                                            @endif
                                                                        </td>


                                                                    </tr>


                                                                @endif
                                                            @endforeach
                                                        @endif
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                   

                       
                    </div>


                </div>


            </div>

        </div>

    </div>
    <div class="modal fade" id="editProductModal" tabindex="-1" aria-labelledby="editProductModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editProductModalLabel">How to Set Up a Product</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
    
                <div class="modal-body">
                    <div style="border:2px solid #0d6efd; background:#e7f1ff; color:#084298; padding:20px;
                        border-radius:10px; font-family:Arial, sans-serif; line-height:1.6; font-size:16px; margin-bottom:20px">
    
                        <ol style="padding-left:20px;">
                            <li><strong>Set up the basics:</strong> Manually create all required colors, brands, and categories in their respective sections on the left-hand side.</li>
                            <li><strong>Add size and variation details:</strong> Enter size and variation details manually only if there are fewer than 10 versions. For more than 10 versions, please use the Mass Upload functionality.</li>
                            <li><strong>Connect variations to categories:</strong> After setting up sizes and variations, make sure to link them — along with the color information — to the corresponding category in the Category section on the left-hand side.</li>
                            <li><strong>Mind the upload limits:</strong> The Mass Upload feature has a limited data capacity. Exceeding this limit can cause part of your upload data to be lost. To avoid issues, reduce your product list to only the items you need to update or adjust.</li>
                            <li><strong>When adding sizes/variations manually:</strong> Remember to also add the same size or variation on the product’s Edit Page by clicking the “Add Another Size/Variation” button.</li>
                        </ol>
    
                    </div>
                </div>
    
                <div class="modal-footer">
                    <button type="button" class="cancel-btn" data-bs-dismiss="modal">Close</button>
                    <a id="goToEditPage" href="#" class="add-user">Go to Edit Page</a>
                </div>
            </div>
        </div>
    </div>
    


    <div class="modal fade modal-delete-logout" id="deleteProductModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="deleteProductModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="p-0 modal-body">
                    <div class="inner-body-delete-logout">
                        <h4 id="delete-text" class="mb-3"></h4>
                        <p id="delete-description" class=" mb-0"></p>
                        <div class="upper-btns-modal-pair">
                            <button type="button" id="confirmToggle" class="comn-modal-btns-blue btn btn-primary">Yes</button>
                            <button type="button" id="cancelToggle" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">No</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade modal-delete-logout" id="deleteProduct" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="deleteProductModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="p-0 modal-body">
                    <div class="inner-body-delete-logout">
                        <h4 id="delete-text">Are you sure you want to delete this product?</h4>
                        <div class="upper-btns-modal-pair">
                            <button type="button" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">No</button>
                            <form id="delete-product-form" method="POST">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="comn-modal-btns-blue add-user">Yes</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="uploadCsvModal" tabindex="-1" aria-labelledby="uploadCsvModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="uploadCsvModalLabel">Upload CSV File</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
    
                <form action="{{ route('admin.products.import') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
    
                        <!-- ⚠️ Warning Panel -->
                        <div style="border:2px solid #dc3545; background:#f8d7da; color:#842029; padding:20px;
                            border-radius:10px; font-family:Arial, sans-serif; line-height:1.6; margin-bottom:20px; font-size:16px">
                            <h4 style="margin-top:0; color:#842029;">⚠️ WARNING</h4>
                            <p>
                                Use this functionality with extreme care. Incorrect use can 
                                <strong>severely disrupt the system</strong> and 
                                <strong>cannot be reversed</strong> without external assistance from 
                                <strong>Deftsoft</strong>.
                            </p>
    
                            <h5 style="margin-bottom:5px;">❌ Do NOT modify the following fields for mass adjustments</h5>
                            <p style="margin-top:0;">Update them only in the <strong>Product Management Module</strong>:</p>
                            <p>
                                <strong>ID, Name, Category, Brand, Railing Type</strong> (⚠️ modifying will break front-end),<br>
                                <strong>Variation ID</strong> (⚠️ will create unremovable products),<br>
                                <strong>Variation Type, Variation Name, Color, SKU</strong> (⚠️ will create unremovable products),<br>
                                <strong>Variation Status, Created At, Updated At</strong>
                            </p>
    
                            <h5 style="margin-bottom:5px;">✅ Allowed fields for mass adjustments</h5>
                            <p>Keywords, Quantity, Variation Weight, Variation Length, Variation Height, Variation Volume, Variation Max. Load</p>
    
                            <h5 style="margin-bottom:5px;">➕ Adding New Products</h5>
                            <ul style="margin:0; padding-left:20px;">
                                <li><strong>Never perform Mass Adjustments and Add New Products with the same upload!</strong></li>
                                <li>In the CSV download file, the <strong>Product ID, Category, and Railing Type</strong> that you want to assign to new products must already exist.</li>
                                <li>If they do not exist, first create the product manually (as far as possible) in the <strong>Product Management Module</strong> before using the Mass Upload functionality.</li>
                                <li>To add new products using the Mass Upload function:
                                    <ol>
                                        <li>Copy the following data from an existing product within the same product category: <strong>Product ID, Product Name, Category, Brand, Keywords, Railing Type, Variation Type, Variation Name, Color, SKU, and Variation Status</strong>.</li>
                                        <li>Paste this information below the last line in your CSV file.</li>
                                        <li>⚠️ <strong>Important:</strong>
                                            <ul>
                                                <li>The <strong>Variation ID</strong> must not be copied directly. It needs to follow an ascending numeric sequence for each new product.</li>
                                                <li>The <strong>Quantity</strong> field can be set to 0 if needed.</li>
                                            </ul>
                                        </li>
                                        <li>Once all information for the new products has been added, upload the updated CSV file to the <strong>Product Management Module</strong>.</li>
                                        <li>You will then find all newly added products in the <strong>Edit Page</strong> of the corresponding product category.</li>
                                    </ol>
                                </li>
                            </ul>
                            
                        </div>
    
                        <!-- File Upload Input -->
                        <div class="mb-3">
                            <label for="csvFile" class="form-label">Select CSV File</label>
                            <input class="form-control" type="file" id="csvFile" name="csv_file" accept=".csv" required>
                            <div class="form-text">Please upload a CSV file in the correct format.</div>
                        </div>
                    </div>
    
                    <div class="modal-footer">
                        <button type="button" class="cancel-btn" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="add-user">Upload</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const editModal = document.getElementById('editProductModal');
            const editLink = document.getElementById('goToEditPage');
        
            editModal.addEventListener('show.bs.modal', function(event) {
                const button = event.relatedTarget; // Button that triggered the modal
                const productId = button.getAttribute('data-product-id'); 
                editLink.href = "{{ route('admin.products.edit', ':id') }}".replace(':id', productId);

            });
        });
        </script>
    
    <script>
   var baseUrl = "{{ rtrim(config('app.url'), '/') }}";
document.querySelectorAll('.variant-status-toggle').forEach(function (toggle) {
        toggle.addEventListener('change', function (e) {
            e.preventDefault(); 
            const checkbox = this;

            checkbox.checked = !checkbox.checked;

            const id = checkbox.dataset.variantId;
            const type = checkbox.dataset.type;
            const isEnabling = !checkbox.checked;
            const status = isEnabling ? 'in_stock' : 'out_of_stock';
            const productName = checkbox.closest('tr').querySelector('td:nth-child(3)')?.textContent?.trim() || 'Product';
            const colorName = checkbox.closest('tr').querySelector('td:nth-child(4)')?.textContent?.trim() || 'SKU';

            pendingToggle = { checkbox, id, type, status };

            const heading = isEnabling
                ? `Do you want to enable ${productName} (${colorName}) all colors?`
                : `Do you want to disable ${productName} (${colorName}) all colors?`;

            const description = isEnabling
                ? `Enabling this product makes it available for rent unless the stock level is 0. Low availability may negatively impact your ratings. We recommend ensuring your stock levels are not constantly at 0.`
                : `Disabling this product will make it permanently unavailable to customers renting from your location.`;

            document.getElementById('delete-text').textContent = heading;
            document.getElementById('delete-description').textContent = description;

            const modal = new bootstrap.Modal(document.getElementById('deleteProductModal'));
            modal.show();
        });
    });

    document.getElementById('confirmToggle').addEventListener('click', function () {
        if (!pendingToggle) return;

        const { checkbox, id, type, status } = pendingToggle;

        fetch(`${baseUrl}/admin/${type}/${id}/status`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ status })
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                checkbox.checked = (status === 'in_stock');
            } else {
                alert('Failed to update status');
            }
        })
        .catch(() => {
            alert('Something went wrong');
        })
        .finally(() => {
            pendingToggle = null;
            location.reload();
            const modalEl = bootstrap.Modal.getInstance(document.getElementById('deleteProductModal'));
            modalEl?.hide();
        });
    });

    document.getElementById('cancelToggle').addEventListener('click', function () {
        pendingToggle = null;
    });
     
     


</script>

<script>

function openDeleteModal(productId) {
    const form = document.getElementById('delete-product-form');
    const action = `{{ url('admin/products') }}/${productId}`;
    form.setAttribute('action', action);

    const modal = new bootstrap.Modal(document.getElementById('deleteProduct'));
    modal.show();
}
function updateDownloadLinks() {
        const timeFilter = document.querySelector('.select-main-head').value;
        const categoryFilter = activeCategory === 'all' ? '' : activeCategory;
        const searchQuery = activeSearch;

        document.querySelector('.download-pdf')?.setAttribute('href', 
            `{{ route('admin.products.download.pdf') }}?time_filter=${timeFilter}&category=${categoryFilter}&search=${encodeURIComponent(searchQuery)}`);

        document.getElementById('download-csv')?.setAttribute('href', 
            `{{ route('admin.products.download.csv') }}?time_filter=${timeFilter}&category=${categoryFilter}&search=${encodeURIComponent(searchQuery)}`);
    }
    document.addEventListener('DOMContentLoaded', function () {
        let activeCategory = 'all';
        let activeSearch = '';
    
        const categoryFilterItems = document.querySelectorAll('.filter-category');
        const dropdownButton = document.querySelector('#categoryFilterDropdown');
        const searchInput = document.getElementById('inputPassword5');
    
        categoryFilterItems.forEach(item => {
            item.addEventListener('click', function (e) {
                e.preventDefault();
    
                categoryFilterItems.forEach(el => el.classList.remove('active'));
                this.classList.add('active');
    
                activeCategory = this.dataset.category;
    
                dropdownButton.innerHTML = `<i class="fa-solid fa-filter"></i> ${this.textContent.trim()}`;
    
                filterProducts();
            });
        });
    
        searchInput.addEventListener('input', function () {
            activeSearch = this.value.trim().toLowerCase();
            filterProducts();
        });
    
        function filterProducts() {
            document.querySelectorAll('.accordion-item').forEach(accordionItem => {
                const headingBtn = accordionItem.querySelector('.accordion-button');
                if (!headingBtn) return;

                const categoryId = headingBtn.dataset.bsTarget.replace('#collapse-', '');
                const matchCategory = activeCategory === 'all' || activeCategory === categoryId;
                let hasVisibleRow = false;

                accordionItem.querySelectorAll('tbody tr').forEach(row => {
                    const rowText = row.textContent.toLowerCase();
                    const matchSearch = activeSearch === '' || rowText.includes(activeSearch);
                    const showRow = matchCategory && matchSearch;

                    row.style.display = showRow ? '' : 'none';
                    if (showRow) hasVisibleRow = true;
                });

                accordionItem.style.display = hasVisibleRow ? '' : 'none';

                const collapse = accordionItem.querySelector('.accordion-collapse');
                if (collapse) {
                    if (hasVisibleRow) {
                        collapse.classList.add('show');
                    } else {
                        collapse.classList.remove('show');
                    }
                }
            });
            // updateDownloadLinks();
        }



        filterProducts();


        const timePeriodSelect = document.querySelector('.select-main-head');
        if (timePeriodSelect) {
            timePeriodSelect.addEventListener('change', function() {
                // updateDownloadLinks();
                const timePeriod = this.value;
                window.location.href = `${window.location.pathname}?time_period=${timePeriod}`;
            });
        }

        document.getElementById('download-pdf')?.addEventListener('click', function() {
            window.location.href = "{{ route('admin.products.download.pdf') }}";
        });

        document.getElementById('download-csv')?.addEventListener('click', function() {
            window.location.href = "{{ route('admin.products.download.csv') }}";
        });


        document.getElementById('download-template')?.addEventListener('click', function() {
            window.location.href = "{{ route('admin.products.export.template') }}";
        });

        document.getElementById('download-csv-new')?.addEventListener('click', function() {
            window.location.href = "{{ route('admin.products.export.full') }}";
        });
        // updateDownloadLinks();
    });
    </script>
    

    @endsection
    