@extends('layouts.admin')
@section('content')
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="{{route('admin.product.index')}}">product management</a>
            <a class="active">Add Product</a>
        </div>
    </div>

    <div class="add-user-form">
        <h3>Add Product</h3>
        <form class="row" method="POST" action="/">
            @csrf

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="meta-title" class="form-label">Meta Title</label>
                    <input type="text" class="form-control" placeholder="Enter Meta Title" id="meta-title" name="meta_title" value="{{ old('meta_title') }}">
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="sub-title" class="form-label">Sub Title</label>
                    <input type="text" class="form-control" placeholder="Enter Sub Title" id="sub-title" name="sub_title" value="{{ old('sub_title') }}">
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="product-category" class="form-label">Product category</label>
                    <select id="product-category" class="form-select" name="product_category">
                        <option value="" selected>Choose...</option>
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="new-categories" class="form-label">Create new categories</label>
                    <div class="btn-category">
                        <input type="text" class="form-control" id="new-categories" name="new_categories" placeholder="Enter new category">
                        <button type="button" class="create-add-btn" id="add-category-btn" data-url="{{ route('admin.category.add') }}">Add</button>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="size-variation" class="form-label">Size/Variation</label>
                    <select id="size-variation" class="form-select" name="size_variation">
                        <option value="" selected>Choose...</option>
                        <option value="1" {{ old('size_variation') == '1' ? 'selected' : '' }}>Size 1</option>
                        <option value="2" {{ old('size_variation') == '2' ? 'selected' : '' }}>Size 2</option>
                    </select>
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="create-size-variation" class="form-label">Create Size/Variation</label>
                    <div class="btn-category">
                        <input type="text" class="form-control" id="create-size-variation" name="create_size_variation" placeholder="Enter" value="{{ old('create_size_variation') }}">
                        <button class="create-add-btn">Add</button>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="product-brand" class="form-label">Product Brand</label>
                    <input type="text" class="form-control" placeholder="Enter Product Brand" id="product-brand" name="product_brand" value="{{ old('product_brand') }}">
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="color" class="form-label">Color</label>
                    <select id="color" class="form-select" name="color">
                        <option value="" selected>Choose...</option>
                        <option value="Black" {{ old('color') == 'Black' ? 'selected' : '' }}>Black</option>
                        <option value="Red" {{ old('color') == 'Red' ? 'selected' : '' }}>Red</option>
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="quantity" class="form-label">Quantity</label>
                    <input type="text" class="form-control" placeholder="Enter Quantity" id="quantity" name="quantity" value="{{ old('quantity') }}">
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="rental-price-1-day" class="form-label">Rental price (for 1 day)</label>
                    <input type="text" class="form-control" placeholder="Enter Rental price" id="rental-price-1-day" name="rental_price_1_day" value="{{ old('rental_price_1_day') }}">
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="rental-price-1-week" class="form-label">Rental Price (after one day for one week)</label>
                    <input type="text" class="form-control" placeholder="Enter Rental price" id="rental-price-1-week" name="rental_price_1_week" value="{{ old('rental_price_1_week') }}">
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="rental-price-after-1-week" class="form-label">Rental Price (after one week)</label>
                    <input type="text" class="form-control" placeholder="Enter Rental price" id="rental-price-after-1-week" name="rental_price_after_1_week" value="{{ old('rental_price_after_1_week') }}">
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="product-dimensions" class="form-label">Product Dimensions </label>
                    <input type="text" class="form-control" placeholder="Enter Height" id="product-heigth" name="dimensions_heigth" value="{{ old('dimensions_heigth') }}">
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="product-dimensions" class="form-label"> </label>
                    <input type="text" class="form-control" placeholder="Enter Width" id="product-width" name="dimensions_width" value="{{ old('dimensions_width') }}">
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="product-weight" class="form-label">Product Weight</label>
                    <input type="text" class="form-control" placeholder="Enter Product Weight" id="product-weight" name="product_weight" value="{{ old('product_weight') }}">
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="status" class="form-label">Status</label>
                    <select id="status" class="form-select" name="status">
                        <option value="" selected>Choose...</option>
                        <option value="In Stock" {{ old('status') == 'In Stock' ? 'selected' : '' }}>In Stock</option>
                    </select>
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="keywords" class="form-label">Keywords</label>
                    <input type="text" class="form-control" placeholder="Enter Keywords" id="keywords" name="keywords" value="{{ old('keywords') }}">
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="status-multiple" class="form-label multiselect-form">Related Product</label>
                    <select class=" form-control multipleSelect2" multiple="true" id="status-multiple" name="status_multiple[]">
                        <option value="1" data-image="{{ asset('admin/images/image (3).png')}}" {{ in_array(1, old('status_multiple', [])) ? 'selected' : '' }}>Excellent</option>
                        <option value="2" data-image="{{ asset('admin/images/image (5).png')}}" {{ in_array(2, old('status_multiple', [])) ? 'selected' : '' }}>Very Good</option>
                        <option value="3" data-image="{{ asset('admin/images/image (6).png')}}" {{ in_array(3, old('status_multiple', [])) ? 'selected' : '' }}>Good</option>
                    </select>
                </div>
            </div>

            <div class="col-md-12">
                <div class="comn-input-select">
                    <label for="meta-description" class="form-label multiselect-form">Meta Description</label>
                    <textarea class="form-control" placeholder="Leave a comment here" id="meta-description" name="meta_description" style="height: 100px">{{ old('meta_description') }}</textarea>
                </div>
            </div>

            <div class="col-md-5">
                <div class="comn-input-select mb-0">
                    <label for="upload-photo" class="form-label multiselect-form">Upload Photos</label>
                </div>
                <div class="upload-img-show d-flex">
                    <div class="main-inpt">
                        <label for="upload-photo" class="upload-img-div">
                            <i class="fa-solid fa-image"></i>
                            <p>Add photos</p>
                        </label>
                        <input type="file" id="upload-photo" class="d-none" name="upload_photo[]" accept="image/*" multiple>
                    </div>
                </div>
                <div id="image-previews" class="d-flex mt-2"></div>
                <p class="support-show">Supports JPG, PNG, and WEBP formats</p>
            </div>
            <div class="col-md-7">
                <div class="comn-input-select mb-0">
                    <label for="upload-main-photo" class="form-label multiselect-form">Upload main Photo</label>
                </div>
                <div class="upload-img-show d-flex">
                    <div class="main-inpt ">
                        <label for="upload-main-photo" class="upload-img-div">
                            <i class="fa-solid fa-image"></i>
                            <p>add a photo</p>
                        </label>
                        <input type="file" id="upload-main-photo" class="d-none" name="upload_main_photo">
                    </div>
                </div>
                <p class="support-show">Supports JPG, PNG, and WEBP formats</p>
            </div>

            <div class="col-12">
                <div class="upper-main-btn-last-comn d-flex btn-main-upload-edit">
                    <button type="submit" class="add-user">add product</button>
                    <!-- <button class="cancel-btn" onclick="history.back()">Cancel</button> -->
                </div>
            </div>
        </form>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>

<script>
    var $j = jQuery.noConflict();
    $j(document).ready(function() {
        $j('#status-multiple').select2({
            placeholder: "Select Status",
            width: '100%',
            templateResult: function(state) {
                if (!state.id) {
                    return state.text;
                }
                var $state = $(
                    '<span><img src="' + $j(state.element).data('image') + '" class="img-flag-select2" /> ' + state.text + '</span>'
                );
                return $state;
            }
        });
    });

    document.getElementById('upload-photo').addEventListener('change', function(event) {
        const fileInput = event.target;
        const fileList = fileInput.files;
        const previewContainer = document.getElementById('image-previews');

        previewContainer.innerHTML = '';

        Array.from(fileList).forEach(file => {
            const reader = new FileReader();

            reader.onload = function(e) {
                const previewWrapper = document.createElement('div');
                previewWrapper.classList.add('preview-item');
                const imgElement = document.createElement('img');
                imgElement.classList.add('preview-item-image');
                imgElement.src = e.target.result;
                imgElement.alt = file.name;
                imgElement.style.width = '100px';
                imgElement.style.marginRight = '10px';

                const removeButton = document.createElement('button');
                removeButton.textContent = 'Remove';
                removeButton.style.marginTop = '5px';
                removeButton.style.display = 'block';
                removeButton.style.backgroundColor = '#f44336';
                removeButton.style.color = '#fff';
                removeButton.style.border = 'none';
                removeButton.style.padding = '5px';
                removeButton.style.cursor = 'pointer';

                removeButton.addEventListener('click', function() {
                    previewWrapper.remove();
                });

                previewWrapper.appendChild(imgElement);
                previewWrapper.appendChild(removeButton);
                previewContainer.appendChild(previewWrapper);
            };

            reader.readAsDataURL(file);
        });
    });
    
</script>
@endsection