@extends('layouts.pdf')

@section('content')
    <h1>Product Analytics Report</h1>
    <p>Generated on: {{ now()->format('d.m.Y') }}</p>

    <table class="table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Category</th>
                <th>SKU</th>
                <th>Size/Variation</th>
                <th>Color</th>
                <th>Total Quantity</th>
                <th>Remaining Quantity</th>
                <th>Dimensions (LxWxH)</th>
                <th>Weight</th>
                <th>Volume</th>
                <th>Max Load</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($products as $product)
                @if($product->variations->isEmpty())
                    <tr>
                        <td>{{ $product->id }}</td>
                        <td>{{ $product->name }}</td>
                        <td>{{ $product->category->name ?? '-' }}</td>
                        <td>{{ $product->sku ?? '-' }}</td>
                        <td>-</td>
                        <td>{{ $product->color->name ?? '-' }}</td>
                        <td>{{ $product->quantity }}</td> {{-- Remaining --}}
                        <td>{{ $product->total_quantity ?? $product->quantity }}</td> {{-- Total --}}
                        <td>{{ $product->length.'x'.$product->width.'x'.$product->height }}</td>
                        <td>{{ $product->weight }}</td>
                        <td>{{ $product->volume }}</td>
                        <td>{{ $product->max_load }}</td>
                        <td>{{ $product->status }}</td>
                    </tr>
                @else
                    @foreach($product->variations as $variation)
                        @foreach($variation->options as $option)
                            <tr>
                                <td>{{ $product->id }}</td>
                                <td>{{ $product->name }}</td>
                                <td>{{ $product->category->name ?? '-' }}</td>
                                <td>{{ $option->sku }}</td>
                                <td>{{ $variation->size->name ?? $variation->variation->name ?? '-' }}</td>
                                <td>{{ $option->color->name ?? '-' }}</td>
                                <td>{{ $option->quantity }}</td> {{-- Remaining --}}
                                <td>{{ $option->total_quantity ?? $option->quantity }}</td> {{-- Total --}}
                                <td>{{ $variation->length.'x'.$variation->width.'x'.$variation->height }}</td>
                                <td>{{ $variation->weight }}</td>
                                <td>{{ $variation->volume }}</td>
                                <td>{{ $variation->max_load }}</td>
                                <td>{{ $variation->status }}</td>
                            </tr>
                        @endforeach
                    @endforeach
                @endif
            @endforeach
        </tbody>
        
    </table>
@endsection