@extends('layouts.admin')

@section('content')
<div class="col-9 main-dash-left">
    <div class="report-and-analys">
        <h6>Report & analytics Management</h6>
    </div>
    <div class="daily-task-report mb-3">
        <div class="row align-items-center">
            <div class="col-md-4">
                <h4>Daily Task Report</h4>
            </div>
            <div class="col-md-5">
                <div class="upper-inpt-main">
                    <div class="from-inp">
                        <p>From</p>
                        <input type="date" class="date-inpt" id="fromDate">
                    </div>
                    <div class="from-inp">
                        <p>To</p>
                        <input type="date" class="date-inpt" id="toDate">
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="sownload-cv-pdf mb-0">
                    <button class="download-pdf" id="downloadPdfBtn">Download PDF</button>
                    <button class="download-pdf" id="downloadCsvBtn">Download CSV</button>
                </div>
            </div>
        </div>
    </div>
    <div class="daily-task-report">
        <div class="row align-items-center">
            <div class="col-md-4">
                <h4>Revenue Report</h4>
            </div>
            <div class="col-md-5">
                <div class="upper-inpt-main">
                    <div class="from-inp">
                        <p>From</p>
                        <input type="date" class="date-inpt" id="fromDateRevenue">
                    </div>
                    <div class="from-inp">
                        <p>To</p>
                        <input type="date" class="date-inpt" id="toDateRevenue">
                    </div>
                </div>
            </div>
            <div class="col-md-3">

                <div class="sownload-cv-pdf mb-0">
                    <button class="download-pdf" id="revenue-pdf">Download PDF</button>
                    <button class="download-pdf" id="revenue-csv">Download CSV</button>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const dailyFrom = document.getElementById('fromDate');
        const dailyTo = document.getElementById('toDate');
        const revenueFrom = document.getElementById('fromDateRevenue');
        const revenueTo = document.getElementById('toDateRevenue');
    
        // Function to enforce ToDate >= FromDate
        function syncToMin(fromInput, toInput) {
            fromInput.addEventListener('change', function () {
                if (this.value) {
                    toInput.min = this.value;
                    if (toInput.value && toInput.value < this.value) {
                        toInput.value = '';
                    }
                } else {
                    toInput.removeAttribute('min');
                }
            });
        }
    
        syncToMin(dailyFrom, dailyTo);
        syncToMin(revenueFrom, revenueTo);
    
        // Daily Task PDF
        document.getElementById('downloadPdfBtn').addEventListener('click', function () {
            const fromDate = dailyFrom.value;
            const toDate = dailyTo.value;
            let url = "{{ route('admin.daily.tasks.export.pdf') }}";
            if (fromDate || toDate) {
                url += '?' + new URLSearchParams({ from_date: fromDate, to_date: toDate });
            }
            window.location.href = url;
        });
    
        // Daily Task CSV
        document.getElementById('downloadCsvBtn').addEventListener('click', function () {
            const fromDate = dailyFrom.value;
            const toDate = dailyTo.value;
            let url = "{{ route('admin.daily.tasks.export.csv') }}";
            if (fromDate || toDate) {
                url += '?' + new URLSearchParams({ from_date: fromDate, to_date: toDate });
            }
            window.location.href = url;
        });
    
        // Revenue PDF
        document.getElementById('revenue-pdf').addEventListener('click', function () {
            const fromDate = revenueFrom.value;
            const toDate = revenueTo.value;
            let url = "{{ route('admin.revenue.tasks.export.pdf') }}";
            if (fromDate || toDate) {
                url += '?' + new URLSearchParams({ from_date: fromDate, to_date: toDate });
            }
            window.location.href = url;
        });
    
        // Revenue CSV
        document.getElementById('revenue-csv').addEventListener('click', function () {
            const fromDate = revenueFrom.value;
            const toDate = revenueTo.value;
            let url = "{{ route('admin.revenue.tasks.export.csv') }}";
            if (fromDate || toDate) {
                url += '?' + new URLSearchParams({ from_date: fromDate, to_date: toDate });
            }
            window.location.href = url;
        });
    });
    </script>
    
@endsection