<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Revenue Report</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 9px; }
        table { width: 100%; border-collapse: collapse; table-layout: fixed; }
        th, td { border: 1px solid #000; padding: 4px; text-align: left; word-wrap: break-word; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
    <h2>Revenue Report</h2>
    <p>From: {{ $fromDate ?? 'Start' }} To: {{ $toDate ?? 'End' }}</p>

    <table>
        <thead>
            <tr>
                @foreach((new \App\Exports\RevenueReportExport())->headings() as $heading)
                    <th>{{ $heading }}</th>
                @endforeach
            </tr>
        </thead>
        <tbody>
            @foreach($bookings as $booking)
            @php
                $item = $booking->items->first();
                $user = $booking->userDetails;
            
                $taxRate = 0.19;
                $insuranceFlatRate = 25.0;
            
                // --- Insurance calculations ---
                $insuranceNet = 0;
                $insuranceTax = 0;
                if ($item->is_insured) {
                    $insuranceNet = $insuranceFlatRate / (1 + $taxRate);
                    $insuranceTax = $insuranceFlatRate - $insuranceNet;
                }
            
                // --- Rent part calculations ---
                $taxableAmount = $item->is_insured ? $item->calculated_rent - $insuranceFlatRate : $item->calculated_rent;
            
                // Apply discount proportionally to the rental part
                $totalRentalGrossBeforeDiscount = $taxableAmount;
                $discountAmount = $booking->discount; // assume discount applies to rental only
                $itemRentalGrossAfterDiscount = max($taxableAmount - $discountAmount, 0);
            
                // Calculate net and tax
                $net = $itemRentalGrossAfterDiscount / (1 + $taxRate);
                $tax = $itemRentalGrossAfterDiscount - $net;
            
                // --- Final totals ---
                $subtotal = $net + $tax; // subtotal of rental part
                $total = $subtotal + $insuranceNet + $insuranceTax; // add insurance net/tax

                $newDropOffDate = optional($booking->new_dropoff_date ? \Carbon\Carbon::parse($booking->new_dropoff_date) : null)->format('d.m.Y');

                $newPickupTime = optional($item->new_dropoff_time ? \Carbon\Carbon::parse($item->new_dropoff_time) : null)->format('H:i');
            
            @endphp
            
                <tr>
                    <td>{{ $booking->id }}</td>
                    <td>{{ $booking->created_at->format('d.m.Y') }}</td>
                    <td>{{ $user->first_name ?? '' }} {{ $user->last_name ?? '' }}</td>
                    <td>{{ $user->address ?? '' }}, {{ $user->zip ?? '' }}, {{ $user->city ?? '' }}, {{ $user->country ?? '' }}</td>
                    <td>{{ $user->email ?? '' }}</td>
                    <td>{{ $user->phone ?? '' }}</td>
                    <td>{{ $item->car_name ?? '' }}</td>
                    <td>{{ $item->model ?? '' }}</td>
                    <td>{{ $item->car_year ?? '' }}</td>
                    <td>{{ $item->roof_type ?? '' }}</td>
                    <td>{{ $item->trailer_hitch ? 'Yes' : 'No' }}</td>
                    <td>{{ $item->days }} days</td>
                    @php
                        $pickupDateTime = \Carbon\Carbon::parse($item->pickup_date->format('Y-m-d') . ' ' . $item->pickup_time);
                        $dropoffDateTime = \Carbon\Carbon::parse($item->dropoff_date->format('Y-m-d') . ' ' . $item->dropoff_time);
                    @endphp
                    <td>{{ $pickupDateTime->format('d.m.Y H:i') }}</td>
                    <td>{{ $dropoffDateTime->format('d.m.Y H:i') }}</td>              
                    <td>{{ $item->product_name ?? '' }}</td>
                    <td>{{ $item->is_carrier_included ? 'Yes' : 'No' }}</td>
                    <td>{{ $item->is_insured ? 'Yes' : 'No' }}</td>
                    <td>{{ number_format($booking->subtotal, 2 , ',' , '.') }}</td>
                    <td>{{ number_format($booking->discount, 2, ',' , '.') }}</td>
                    <td>{{ number_format($insuranceNet, 2, ',' , '.') }}</td>
                    <td>{{ number_format($net, 2, ',' , '.') }}</td>
                    <td>{{ number_format($tax + $insuranceTax, 2, ',' , '.') }}</td>
                    <td>{{ number_format($total, 2, ',' , '.') }}</td>
                    <td>{{ number_format($booking->refund_amount, 2, ',' , '.') }}</td>
                    <td>{{ number_format($booking->delay_fees, 2, ',' , '.') }}</td>
                    <td>{{ number_format($booking->additional_days_rent, 2, ',' , '.') }}</td>
                    <td>{{ $booking->status == 'cancelled' ? 'Yes' : 'No' }}</td>
                    <td>{{ $item->damage ? 'Yes': 'No' }}</td>
                    <td>{{ $item->delay  ? 'Yes' : 'No' }}</td>
                    <td>{{$item->additional_days}} </td>
                    <td>{{$newDropOffDate}} </td>
                    <td>{{$newPickupTime}} </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
