@extends('layouts.admin')
@section('content')

<div class="col-9 main-dash-left sora-font">
    <div class="analytics">
        <div class="name-head">
            <h2>SPO Analytics</h2>
            <div class="d-flex comm_head_top_right">
            <div class="sownload-cv-pdf">
                <a href="#" class="download-csv" onclick="exportData('csv')">Download CSV</a>
                <a href="#" class="download-pdf" onclick="exportData('pdf')">Download PDF</a>
            </div>
            <select class="form-select select-main-head" aria-label="Default select example" id="timeFilter">
                <option value="year" {{ request('time_filter', 'year') == 'year' ? 'selected' : '' }}>Year</option>
                <option value="month" {{ request('time_filter') == 'month' ? 'selected' : '' }}>Month</option>
                <option value="week" {{ request('time_filter') == 'week' ? 'selected' : '' }}>Week</option>
                <option value="day" {{ request('time_filter') == 'day' ? 'selected' : '' }}>Day</option>
            </select>
        </div>
        </div>
       
       
        <div class="cards-dashboard">
            <div class="row row-gap-3">
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-green">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="{{asset('admin/images/total.png')}}" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Total SPOs</p>
                                    <h4>{{ $analytics['total_users'] }}</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="{{asset('admin/images/green-line.png')}}" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-purple">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="{{asset('admin/images/return.png')}}" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Active FullTimers</p>
                                    <h4>{{ $analytics['fulltimer'] }}</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="{{asset('admin/images/white-line.png')}}" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-yellow">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="{{asset('admin/images/top.png')}}" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Active Side Businesses</p>
                                    <h4>{{ $analytics['sidebusiness'] }}</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="{{asset('admin/images/orange-line.png')}}" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-purple">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="{{asset('admin/images/return.png')}}" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Active SPO</p>
                                    <h4>{{ $analytics['active'] }}</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="{{asset('admin/images/white-line.png')}}" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <form id="exportForm" method="GET" action="{{ route('admin.spo.download.csv') }}" style="display: none;">
                <input type="hidden" name="search" id="exportSearch">
                <input type="hidden" name="sort_by" id="exportSort">
                <input type="hidden" name="time_filter" id="exportTimeFilter">
                <input type="hidden" name="status_filter" id="exportStatusFilter"> 
            </form>
        </div>
        
        
        <div class="main-notification-messege">
            <div class="notifi-list d-flex">
                <h6>SPO Management</h6>
                <div class="dropdowns-inner-list d-flex">
                    <div class="dropdowns-inner-list">
                        <div class="icon-search-main">
                            <i class="fa-solid fa-magnifying-glass"></i>
                            <input aria-describedby="passwordHelpBlock" placeholder="Search For SPO" type="text" id="searchUser" class="form-control" value="{{ request('search') }}">
                        </div>
                    </div>
                    <div class="filter-main-div">
                        <p class="lable-filt">Status:</p>
                        <div class="dropdown">
                            <button class="filter-btn dropdown-toggle" type="button" id="statusFilterDropdown"
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa-solid fa-filter"></i>
                                {{ request('status_filter', 'all') == 'active' ? 'Active' : (request('status_filter') == 'inactive' ? 'Blocked' : 'Filter') }}
                            </button>
                            <ul class="dropdown-menu" aria-labelledby="statusFilterDropdown">
                                <li><a class="dropdown-item status-option {{ request('status_filter', 'all') == 'all' ? 'active' : '' }}" href="#" data-value="all">Filter</a></li>
                                <li><a class="dropdown-item status-option {{ request('status_filter') == 'active' ? 'active' : '' }}" href="#" data-value="active">Active</a></li>
                                <li><a class="dropdown-item status-option {{ request('status_filter') == 'inactive' ? 'active' : '' }}" href="#" data-value="inactive">Blocked</a></li>
                                <li><a class="dropdown-item status-option {{ request('status_filter') == 'closed' ? 'active' : '' }}" href="#" data-value="closed">Closed</a></li>

                            </ul>
                        </div>
                    </div>
                    
                    <form id="statusForm" method="GET">
                        <input type="hidden" name="status_filter" id="statusInput" value="{{ request('status_filter', 'all') }}">
                    </form>
                    
                    <a class="add-notification-btn" href="{{route('admin.spo.create')}}">Add New SPO</a>
                </div>
            </div>
            <div class="notification-table pt-0">
                <table id="productTable" class="table">
                    <thead>
                        <tr class="head-class-td">
                            <th>SPO ID</th>
                            <th>SPO Name</th>
                            <th>City</th>
                            <th>Phone Number</th>
                            <th>Business Type </th>
                            <th>Business Model</th>
                            <th>Size Of Location</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody id="userResults">
                        @foreach($vendors as $vendor)
                        <tr>
                            <td>#{{$vendor->id}}</td>
                            <td>{{ $vendor->first_name . ' ' . $vendor->last_name }}</td>
                            <td>{{$vendor->city}}</td>
                            <td>{{ $vendor->country_code . ' ' . $vendor->number }}</td>
                            <td>{{ $vendor->business_type ? __('messages.' . $vendor->business_type) : 'N/A' }}</td>
                            <td>{{$vendor->business_model ? __('messages.' . $vendor->business_model) : 'N/A'}}</td>
                            <td>{{$vendor->size_of_location ? __('messages.' . $vendor->size_of_location) : 'N/A'}}</td>
                            <td>
                                <select class="form-select select-active-block"
                                    onchange="openStatusChangeModal('{{ $vendor->id }}', this.value, this)"
                                    data-current-status="{{ $vendor->status == 'active' ? 'Active' : ($vendor->status == 'closed' ? 'Closed' : 'Blocked') }}"
                                    >
                                    <option data-status='Active' class="active-op" value="Active" {{ $vendor->status == 'active' ? 'selected' : '' }}>Active</option>
                                    <option class="block-op" data-status='Blocked' value="Blocked" {{ $vendor->status == 'inactive' ? 'selected' : '' }}>Blocked</option>
                                    <option class="completed-op" data-status='Closed' value="Closed" {{ $vendor->status == 'closed' ? 'selected' : '' }}>Closed</option>

                                </select>
                            </td>
                            <td>
                                <div class="upper-delete-btns d-flex">
                                    <a class="view-btn-eye" href="{{route('admin.spo.show', $vendor)}}">
                                        <i class="fa-solid fa-eye"></i>
                                    </a>
                                    <a class="edit-btn-eye" href="{{route('admin.spo.edit', $vendor)}}">
                                        <i class="fa-solid fa-pen-to-square"></i>
                                    </a>

                                    <a class="delete-btn-eye" href="javascript:void(0);" onclick="openDeleteModal('{{ $vendor }}')">
                                        <i class="fa-solid fa-trash"></i>
                                    </a>
                                   
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                
            </div>
        </div>
    </div>
</div>

<!-- Status Change Modal -->
<div class="modal fade modal-delete-logout" id="changestatus" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="status-text">Are you sure you want to change status?</h4>
                    <p><strong>Attention:</strong> The following information must be added to SPO profile, before changing the SPO status into active, Otherwise the front end will show breaks!</p>
                    <ol>
    <li>Conditions</li>
    <li>Working Hours</li>
    <li>Enabling Categories SPO provides</li>
    <li>Adding stock to the enabled categories</li>
</ol>
<p style="margin-bottom : 16px">All other information can also be added after the account has been activated.</p>

                    <div class="upper-btns-modal-pair">
                        <button type="button" class="comn-modal-btns-transparent btn btn-primary" data-bs-dismiss="modal" onclick="resetStatusSelect()">No</button>
                        <form id="status-change-form" method="POST" action="{{ route('admin.spo.status') }}">
                            @csrf
                            <input type="hidden" name="user_id" id="user-id">
                            <input type="hidden" name="new_status" id="new-status">
                            <button type="submit" class="comn-modal-btns-blue btn btn-primary">Yes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade modal-delete-logout" id="deleteuser" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="delete-text">Are you sure you want to delete this SPO?</h4>
                    <div class="upper-btns-modal-pair">
                        <button type="button" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">No</button>
                        <form id="delete-user-form" method="POST" action="{{ route('admin.spo.destroy') }}">
                            @csrf
                            <input type="hidden" name="user_id" id="delete-user-id">
                            <button type="submit" class="comn-modal-btns-blue btn add-user">Yes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $('#delete-user-form').on('submit', function(e) {
        e.preventDefault();
    
        let form = $(this);
        let url = form.attr('action');
        let formData = form.serialize();
    
        $.post(url, formData, function(response) {
            if (response.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Deleted!',
                    text: 'Vendor has been deleted successfully.',
                    confirmButtonText: 'OK'
                }).then(() => {
                    // Optional: remove the vendor row from table or reload page
                    location.reload(); // or remove row via JS
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: response.message || 'Unable to delete vendor.',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
    </script>

<script>
    $(document).ready(function () {
        $('#productTable').DataTable({
        paging: true,
        searching: true, 
        info: true,
        lengthChange: true,
        pageLength: 10,
        ordering: false, 
        language: {
            lengthMenu: 'Show _MENU_ entries',
            paginate: {
                previous: '&laquo;',
                next: '&raquo;'
            }
            },
            dom: '<"top"lf>rt<"bottom"ip><"clear">'
        });

      
    });
    $(document).ready(function() {
        document.getElementById('timeFilter').addEventListener('change', function() {
            const timeFilter = this.value;
            const url = new URL(window.location.href);
            url.searchParams.set('time_filter', timeFilter);
            window.location.href = url.toString();
        });
    });

    document.querySelectorAll('.status-option').forEach(item => {
    item.addEventListener('click', function (e) {
        e.preventDefault();
        const statusValue = this.getAttribute('data-value');
        document.getElementById('statusInput').value = statusValue;
        document.getElementById('statusForm').submit();
    });
});
    
    let statusSelectEl = null;
    
    function openStatusChangeModal(userId, newStatus, selectEl) {
        statusSelectEl = selectEl;
        const statusText = newStatus === 'Active'
    ? 'Are you sure you want to activate this SPO?'
    : (newStatus === 'Closed'
        ? 'Are you sure you want to close this SPO?'
        : 'Are you sure you want to block this SPO?');

        document.getElementById('status-text').innerText = statusText;
        document.getElementById('user-id').value = userId;
        document.getElementById('new-status').value = newStatus;

        const modal = new bootstrap.Modal(document.getElementById('changestatus'));
        modal.show();
    }

    function resetStatusSelect() {
        if (statusSelectEl) {
            const current = statusSelectEl.getAttribute('data-current-status');
            statusSelectEl.value = current;
        }
    }

    function openDeleteModal(userId) {
        document.getElementById('delete-user-id').value = userId;
        const modal = new bootstrap.Modal(document.getElementById('deleteuser'));
        modal.show();
    }

    $(document).ready(function() {
        $('#searchUser').on('keyup', function() {
            let searchQuery = $(this).val().toLowerCase();  
            $('.download-pdf, .download-csv').each(function() {
                let href = $(this).attr('href').split('?')[0];
                $(this).attr('href', href + '?search=' + encodeURIComponent(searchQuery));
            });
            $('#productTable').DataTable().search(this.value).draw();
            // $('#userResults tr').each(function() {  
            //     let rowText = $(this).text().toLowerCase();  
            //     $(this).toggle(rowText.indexOf(searchQuery) > -1);
            // });
        });
    });
    
    // function exportData(type) {
    //     $('#exportSearch').val($('#searchUser').val());
    //     $('#exportSort').val("{{ request('sort_by', 'desc') }}");
    //     $('#exportTimeFilter').val($('#timeFilter').val());
        
    //     let action = type === 'csv' 
    //         ? "{{ route('admin.spo.download.csv') }}" 
    //         : "{{ route('admin.spo.download.pdf') }}";
    //     $('#exportForm').attr('action', action);
    //     $('#exportForm').submit();
    // }

    function exportData(type) {
        $('#exportSearch').val($('#searchUser').val());
        $('#exportSort').val("{{ request('sort_by', 'desc') }}");
        $('#exportTimeFilter').val($('#timeFilter').val());
        $('#exportStatusFilter').val("{{ request('status_filter', 'all') }}"); // pass current status filter
        
        let action = type === 'csv' 
            ? "{{ route('admin.spo.download.csv') }}" 
            : "{{ route('admin.spo.download.pdf') }}";
        $('#exportForm').attr('action', action);
        $('#exportForm').submit();
    }
</script>
@endsection