<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>SPO List</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0;
            padding: 0;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            font-size: 12px; 
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 6px; 
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        @page {
            size: landscape; 
            margin: 10mm; 
        }
    </style>
</head>
<body>
    <h2>SPO List - {{ now()->format('d.m.Y') }}</h2>

    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Full Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Business Type</th>
                <th>Business Model</th>
                <th>Contract Type</th>
                <th>Size of Location</th>
                <th>City</th>
                <th>Status</th>
                
            </tr>
        </thead>
        <tbody>
            @foreach($vendors as $index => $vendor)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $vendor->title }} {{ $vendor->first_name }} {{ $vendor->last_name }}</td>
                    <td>{{ $vendor->email }}</td>
                    <td>{{ $vendor->country_code }} {{ $vendor->number }}</td>
                   <td>{{ $vendor->business_type ? __('messages.' . $vendor->business_type) : 'N/A' }}</td>
                     <td>{{ $vendor->business_model ? __('messages.' . $vendor->business_model) : 'N/A' }}</td>
                    <<td>{{ $vendor->contact_person  ? __('messages.' . $vendor->contact_person) : 'N/A' }}</td>
                    <td>{{ $vendor->size_of_location  ? __('messages.' . $vendor->size_of_location) : 'N/A' }}</td>
                    <td>{{ $vendor->city }}</td>
                    <td>{{ $vendor->status == 'active' ? 'Active' : 'Blocked' }}</td>
                    
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
