<!DOCTYPE html>
<html>
<head>
    <title>SPO Product Report</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0;
            padding: 0;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            font-size: 12px; 
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 6px; 
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        @page {
            size: landscape; 
            margin: 10mm; 
        }
    </style>
</head>
<body>
    <h2>SPO Product Report</h2>
    <table>
        <thead>
            <tr>
                <th>SPO ID</th>
                <th>SPO Name</th>
                <th>City</th>
                @foreach ($products as $product)
                    <th>{{ $product->name }}</th>
                @endforeach
            </tr>
        </thead>
        <tbody>
            @foreach ($vendors as $vendor)
                <tr>
                    <td>#{{ $vendor->id }}</td>
                    <td>{{ $vendor->first_name }} {{ $vendor->last_name }}</td>
                    <td>{{ $vendor->city }}</td>
                    @foreach ($products as $product)
                        @php
                            $key = $vendor->id . '-' . $product->id;
                            $qty = $quantities[$key]->total_quantity ?? 0;
                        @endphp
                        <td>{{ $qty }}</td>
                    @endforeach
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
